/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.catalog.model.system.OperationProtocol;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystemLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.system.SystemRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemMapper;
import org.springframework.stereotype.Component;

@Component
public class SystemMapperImpl
implements SystemMapper {
    @Override
    public SystemDTO toDTO(IntegrationSystem system) {
        if (system == null) {
            return null;
        }
        SystemDTO systemDTO = new SystemDTO();
        systemDTO.setType(system.getIntegrationSystemType());
        systemDTO.setProtocol(this.systemProtocolValue(system));
        systemDTO.setExtendedProtocol(this.protocolToString(system.getProtocol()));
        systemDTO.setSpecification(this.systemProtocolType(system));
        systemDTO.setId(system.getId());
        systemDTO.setName(system.getName());
        systemDTO.setDescription(system.getDescription());
        systemDTO.setInternalServiceName(system.getInternalServiceName());
        systemDTO.setLabels(this.integrationSystemLabelSetToSystemLabelDTOList(system.getLabels()));
        systemDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)system.getCreatedWhen()));
        systemDTO.setCreatedBy(this.userToUserDTO(system.getCreatedBy()));
        systemDTO.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)system.getModifiedWhen()));
        systemDTO.setModifiedBy(this.userToUserDTO(system.getModifiedBy()));
        systemDTO.setActiveEnvironmentId(this.getActiveEnvironmentId(system));
        return systemDTO;
    }

    @Override
    public IntegrationSystem toSystem(SystemRequestDTO dto) {
        if (dto == null) {
            return null;
        }
        IntegrationSystem.IntegrationSystemBuilder integrationSystem = IntegrationSystem.builder();
        integrationSystem.integrationSystemType(dto.getType());
        integrationSystem.name(dto.getName());
        integrationSystem.description(dto.getDescription());
        integrationSystem.activeEnvironmentId(dto.getActiveEnvironmentId());
        integrationSystem.labels(this.systemLabelDTOListToIntegrationSystemLabelSet(dto.getLabels()));
        return integrationSystem.build();
    }

    @Override
    public List<SystemDTO> toResponseDTOs(List<IntegrationSystem> systems) {
        if (systems == null) {
            return null;
        }
        ArrayList<SystemDTO> list = new ArrayList<SystemDTO>(systems.size());
        for (IntegrationSystem integrationSystem : systems) {
            list.add(this.toDTO(integrationSystem));
        }
        return list;
    }

    @Override
    public void mergeWithoutLabels(SystemRequestDTO systemDto, IntegrationSystem system) {
        if (systemDto == null) {
            return;
        }
        system.setName(systemDto.getName());
        system.setDescription(systemDto.getDescription());
        system.setActiveEnvironmentId(systemDto.getActiveEnvironmentId());
    }

    @Override
    public void patchMergeWithoutLabels(SystemRequestDTO systemDto, IntegrationSystem system) {
        if (systemDto == null) {
            return;
        }
        if (systemDto.getName() != null) {
            system.setName(systemDto.getName());
        }
        if (systemDto.getDescription() != null) {
            system.setDescription(systemDto.getDescription());
        }
        if (systemDto.getActiveEnvironmentId() != null) {
            system.setActiveEnvironmentId(systemDto.getActiveEnvironmentId());
        }
    }

    @Override
    public IntegrationSystemLabel asLabelRequest(SystemLabelDTO snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        IntegrationSystemLabel.IntegrationSystemLabelBuilder integrationSystemLabel = IntegrationSystemLabel.builder();
        integrationSystemLabel.name(snapshotLabel.getName());
        if (snapshotLabel.getTechnical() != null) {
            integrationSystemLabel.technical(snapshotLabel.getTechnical().booleanValue());
        }
        return integrationSystemLabel.build();
    }

    @Override
    public List<IntegrationSystemLabel> asLabelRequests(List<SystemLabelDTO> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<IntegrationSystemLabel> list = new ArrayList<IntegrationSystemLabel>(snapshotLabel.size());
        for (SystemLabelDTO systemLabelDTO : snapshotLabel) {
            list.add(this.asLabelRequest(systemLabelDTO));
        }
        return list;
    }

    @Override
    public SystemLabelDTO asLabelResponse(IntegrationSystemLabel snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SystemLabelDTO.SystemLabelDTOBuilder systemLabelDTO = SystemLabelDTO.builder();
        systemLabelDTO.name(snapshotLabel.getName());
        systemLabelDTO.technical(snapshotLabel.isTechnical());
        return systemLabelDTO.build();
    }

    @Override
    public List<SystemLabelDTO> asLabelResponse(List<IntegrationSystemLabel> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SystemLabelDTO> list = new ArrayList<SystemLabelDTO>(snapshotLabel.size());
        for (IntegrationSystemLabel integrationSystemLabel : snapshotLabel) {
            list.add(this.asLabelResponse(integrationSystemLabel));
        }
        return list;
    }

    private String systemProtocolValue(IntegrationSystem integrationSystem) {
        if (integrationSystem == null) {
            return null;
        }
        OperationProtocol protocol = integrationSystem.getProtocol();
        if (protocol == null) {
            return null;
        }
        String value = protocol.getValue();
        if (value == null) {
            return null;
        }
        return value;
    }

    private String systemProtocolType(IntegrationSystem integrationSystem) {
        if (integrationSystem == null) {
            return null;
        }
        OperationProtocol protocol = integrationSystem.getProtocol();
        if (protocol == null) {
            return null;
        }
        String type = protocol.getType();
        if (type == null) {
            return null;
        }
        return type;
    }

    protected List<SystemLabelDTO> integrationSystemLabelSetToSystemLabelDTOList(Set<IntegrationSystemLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SystemLabelDTO> list = new ArrayList<SystemLabelDTO>(set.size());
        for (IntegrationSystemLabel integrationSystemLabel : set) {
            list.add(this.asLabelResponse(integrationSystemLabel));
        }
        return list;
    }

    protected UserDTO userToUserDTO(User user) {
        if (user == null) {
            return null;
        }
        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();
        userDTO.id(user.getId());
        userDTO.username(user.getUsername());
        return userDTO.build();
    }

    protected Set<IntegrationSystemLabel> systemLabelDTOListToIntegrationSystemLabelSet(List<SystemLabelDTO> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<IntegrationSystemLabel> set = new LinkedHashSet<IntegrationSystemLabel>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (SystemLabelDTO systemLabelDTO : list) {
            set.add(this.asLabelRequest(systemLabelDTO));
        }
        return set;
    }
}

