/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.rest.v1.mapping;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.dto.BaseResponse;
import org.qubership.integration.platform.catalog.model.dto.user.UserDTO;
import org.qubership.integration.platform.catalog.model.system.SystemModelSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.User;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.catalog.util.MapperUtils;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.OperationBaseDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SystemModelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.SystemModelLabelDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.ChainBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.OperationBaseMapper;
import org.qubership.integration.platform.designtime.catalog.rest.v1.mapping.SystemModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemModelMapperImpl
implements SystemModelMapper {
    @Autowired
    private ChainBaseMapper chainBaseMapper;
    @Autowired
    private OperationBaseMapper operationBaseMapper;

    @Override
    public SystemModelDTO toSystemModelDTO(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SystemModelDTO systemModelDTO = new SystemModelDTO();
        systemModelDTO.setId(systemModel.getId());
        systemModelDTO.setName(systemModel.getName());
        systemModelDTO.setSpecificationGroupId(this.systemModelSpecificationGroupId(systemModel));
        systemModelDTO.setDeprecated(systemModel.isDeprecated());
        systemModelDTO.setSystemId(this.systemModelSpecificationGroupSystemId(systemModel));
        systemModelDTO.setDescription(systemModel.getDescription());
        systemModelDTO.setVersion(systemModel.getVersion());
        if (systemModel.getSource() != null) {
            systemModelDTO.setSource(systemModel.getSource().name());
        }
        systemModelDTO.setCreatedWhen(MapperUtils.fromTimestamp((Timestamp)systemModel.getCreatedWhen()));
        systemModelDTO.setCreatedBy(this.userToUserDTO(systemModel.getCreatedBy()));
        systemModelDTO.setModifiedWhen(MapperUtils.fromTimestamp((Timestamp)systemModel.getModifiedWhen()));
        systemModelDTO.setModifiedBy(this.userToUserDTO(systemModel.getModifiedBy()));
        systemModelDTO.setChains(this.chainBaseMapper.asDTO(systemModel.getChains()));
        systemModelDTO.setLabels(this.systemModelLabelSetToSystemModelLabelDTOList(systemModel.getLabels()));
        systemModelDTO.setOperations(this.operationBaseMapper.toDTOs(systemModel.getOperations()));
        return systemModelDTO;
    }

    @Override
    public List<SystemModelDTO> toSystemModelDTOs(List<SystemModel> systemModels) {
        if (systemModels == null) {
            return null;
        }
        ArrayList<SystemModelDTO> list = new ArrayList<SystemModelDTO>(systemModels.size());
        for (SystemModel systemModel : systemModels) {
            list.add(this.toSystemModelDTO(systemModel));
        }
        return list;
    }

    @Override
    public void merge(SystemModelDTO systemDto, SystemModel systemModel) {
        if (systemDto == null) {
            return;
        }
        systemModel.setId(systemDto.getId());
        systemModel.setName(systemDto.getName());
        systemModel.setDescription(systemDto.getDescription());
        systemModel.setCreatedWhen(MapperUtils.toTimestamp((Long)systemDto.getCreatedWhen()));
        systemModel.setModifiedWhen(MapperUtils.toTimestamp((Long)systemDto.getModifiedWhen()));
        if (systemDto.getCreatedBy() != null) {
            if (systemModel.getCreatedBy() == null) {
                systemModel.setCreatedBy(User.builder().build());
            }
            this.userDTOToUser(systemDto.getCreatedBy(), systemModel.getCreatedBy());
        } else {
            systemModel.setCreatedBy(null);
        }
        if (systemDto.getModifiedBy() != null) {
            if (systemModel.getModifiedBy() == null) {
                systemModel.setModifiedBy(User.builder().build());
            }
            this.userDTOToUser(systemDto.getModifiedBy(), systemModel.getModifiedBy());
        } else {
            systemModel.setModifiedBy(null);
        }
        if (systemModel.getLabels() != null) {
            set = this.systemModelLabelDTOListToSystemModelLabelSet(systemDto.getLabels());
            if (set != null) {
                systemModel.getLabels().clear();
                systemModel.getLabels().addAll(set);
            } else {
                systemModel.setLabels(null);
            }
        } else {
            set = this.systemModelLabelDTOListToSystemModelLabelSet(systemDto.getLabels());
            if (set != null) {
                systemModel.setLabels(set);
            }
        }
        if (systemDto.getDeprecated() != null) {
            systemModel.setDeprecated(systemDto.getDeprecated().booleanValue());
        }
        systemModel.setVersion(systemDto.getVersion());
        if (systemDto.getSource() != null) {
            systemModel.setSource(Enum.valueOf(SystemModelSource.class, systemDto.getSource()));
        } else {
            systemModel.setSource(null);
        }
        if (systemModel.getOperations() != null) {
            list = this.operationBaseDTOListToOperationList(systemDto.getOperations());
            if (list != null) {
                systemModel.getOperations().clear();
                systemModel.getOperations().addAll(list);
            } else {
                systemModel.setOperations(null);
            }
        } else {
            list = this.operationBaseDTOListToOperationList(systemDto.getOperations());
            if (list != null) {
                systemModel.setOperations(list);
            }
        }
        if (systemModel.getChains() != null) {
            list1 = this.baseResponseListToChainList(systemDto.getChains());
            if (list1 != null) {
                systemModel.getChains().clear();
                systemModel.getChains().addAll(list1);
            } else {
                systemModel.setChains(null);
            }
        } else {
            list1 = this.baseResponseListToChainList(systemDto.getChains());
            if (list1 != null) {
                systemModel.setChains(list1);
            }
        }
    }

    @Override
    public SystemModel asEntity(SystemModelDTO model) {
        if (model == null) {
            return null;
        }
        SystemModel.SystemModelBuilder systemModel = SystemModel.builder();
        systemModel.id(model.getId());
        systemModel.name(model.getName());
        systemModel.description(model.getDescription());
        systemModel.createdWhen(MapperUtils.toTimestamp((Long)model.getCreatedWhen()));
        systemModel.modifiedWhen(MapperUtils.toTimestamp((Long)model.getModifiedWhen()));
        systemModel.createdBy(this.userDTOToUser1(model.getCreatedBy()));
        systemModel.modifiedBy(this.userDTOToUser1(model.getModifiedBy()));
        if (model.getDeprecated() != null) {
            systemModel.deprecated(model.getDeprecated().booleanValue());
        }
        systemModel.version(model.getVersion());
        if (model.getSource() != null) {
            systemModel.source(Enum.valueOf(SystemModelSource.class, model.getSource()));
        }
        systemModel.operations(this.operationBaseDTOListToOperationList(model.getOperations()));
        systemModel.labels(this.systemModelLabelDTOListToSystemModelLabelSet(model.getLabels()));
        systemModel.chains(this.baseResponseListToChainList(model.getChains()));
        return systemModel.build();
    }

    @Override
    public SystemModelLabel asLabelRequest(SystemModelLabelDTO snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SystemModelLabel.SystemModelLabelBuilder systemModelLabel = SystemModelLabel.builder();
        systemModelLabel.name(snapshotLabel.getName());
        if (snapshotLabel.getTechnical() != null) {
            systemModelLabel.technical(snapshotLabel.getTechnical().booleanValue());
        }
        return systemModelLabel.build();
    }

    @Override
    public List<SystemModelLabel> asLabelRequests(List<SystemModelLabelDTO> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SystemModelLabel> list = new ArrayList<SystemModelLabel>(snapshotLabel.size());
        for (SystemModelLabelDTO systemModelLabelDTO : snapshotLabel) {
            list.add(this.asLabelRequest(systemModelLabelDTO));
        }
        return list;
    }

    @Override
    public SystemModelLabelDTO asLabelResponse(SystemModelLabel snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        SystemModelLabelDTO.SystemModelLabelDTOBuilder systemModelLabelDTO = SystemModelLabelDTO.builder();
        systemModelLabelDTO.name(snapshotLabel.getName());
        systemModelLabelDTO.technical(snapshotLabel.isTechnical());
        return systemModelLabelDTO.build();
    }

    @Override
    public List<SystemModelLabelDTO> asLabelResponse(List<SystemModelLabel> snapshotLabel) {
        if (snapshotLabel == null) {
            return null;
        }
        ArrayList<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>(snapshotLabel.size());
        for (SystemModelLabel systemModelLabel : snapshotLabel) {
            list.add(this.asLabelResponse(systemModelLabel));
        }
        return list;
    }

    private String systemModelSpecificationGroupId(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if (specificationGroup == null) {
            return null;
        }
        String id = specificationGroup.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String systemModelSpecificationGroupSystemId(SystemModel systemModel) {
        if (systemModel == null) {
            return null;
        }
        SpecificationGroup specificationGroup = systemModel.getSpecificationGroup();
        if (specificationGroup == null) {
            return null;
        }
        IntegrationSystem system = specificationGroup.getSystem();
        if (system == null) {
            return null;
        }
        String id = system.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    protected UserDTO userToUserDTO(User user) {
        if (user == null) {
            return null;
        }
        UserDTO.UserDTOBuilder userDTO = UserDTO.builder();
        userDTO.id(user.getId());
        userDTO.username(user.getUsername());
        return userDTO.build();
    }

    protected List<SystemModelLabelDTO> systemModelLabelSetToSystemModelLabelDTOList(Set<SystemModelLabel> set) {
        if (set == null) {
            return null;
        }
        ArrayList<SystemModelLabelDTO> list = new ArrayList<SystemModelLabelDTO>(set.size());
        for (SystemModelLabel systemModelLabel : set) {
            list.add(this.asLabelResponse(systemModelLabel));
        }
        return list;
    }

    protected void userDTOToUser(UserDTO userDTO, User mappingTarget) {
        if (userDTO == null) {
            return;
        }
        mappingTarget.setId(userDTO.getId());
        mappingTarget.setUsername(userDTO.getUsername());
    }

    protected Set<SystemModelLabel> systemModelLabelDTOListToSystemModelLabelSet(List<SystemModelLabelDTO> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<SystemModelLabel> set = new LinkedHashSet<SystemModelLabel>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (SystemModelLabelDTO systemModelLabelDTO : list) {
            set.add(this.asLabelRequest(systemModelLabelDTO));
        }
        return set;
    }

    protected User userDTOToUser1(UserDTO userDTO) {
        if (userDTO == null) {
            return null;
        }
        User.UserBuilder user = User.builder();
        user.id(userDTO.getId());
        user.username(userDTO.getUsername());
        return user.build();
    }

    protected Chain baseResponseToChain(BaseResponse baseResponse) {
        if (baseResponse == null) {
            return null;
        }
        Chain.ChainBuilder chain = Chain.builder();
        chain.id(baseResponse.getId());
        chain.name(baseResponse.getName());
        chain.description(baseResponse.getDescription());
        chain.createdWhen(MapperUtils.toTimestamp((Long)baseResponse.getCreatedWhen()));
        chain.modifiedWhen(MapperUtils.toTimestamp((Long)baseResponse.getModifiedWhen()));
        chain.createdBy(this.userDTOToUser1(baseResponse.getCreatedBy()));
        chain.modifiedBy(this.userDTOToUser1(baseResponse.getModifiedBy()));
        return chain.build();
    }

    protected List<Chain> baseResponseListToChainList(List<BaseResponse> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Chain> list1 = new ArrayList<Chain>(list.size());
        for (BaseResponse baseResponse : list) {
            list1.add(this.baseResponseToChain(baseResponse));
        }
        return list1;
    }

    protected Operation operationBaseDTOToOperation(OperationBaseDTO operationBaseDTO) {
        if (operationBaseDTO == null) {
            return null;
        }
        Operation.OperationBuilder operation = Operation.builder();
        operation.id(operationBaseDTO.getId());
        operation.name(operationBaseDTO.getName());
        operation.description(operationBaseDTO.getDescription());
        operation.method(operationBaseDTO.getMethod());
        operation.path(operationBaseDTO.getPath());
        operation.chains(this.baseResponseListToChainList(operationBaseDTO.getChains()));
        return operation.build();
    }

    protected List<Operation> operationBaseDTOListToOperationList(List<OperationBaseDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Operation> list1 = new ArrayList<Operation>(list.size());
        for (OperationBaseDTO operationBaseDTO : list) {
            list1.add(this.operationBaseDTOToOperation(operationBaseDTO));
        }
        return list1;
    }
}

