/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.Quantity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.DependencyRepository;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.DependencyValidationException;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.service.ElementService;
import org.qubership.integration.platform.designtime.catalog.utils.OldContainerUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DependencyService {
    private static final String DEPENDENCY_WITH_ID_NOT_FOUND_MESSAGE = "Can't find dependency with id: ";
    private final DependencyRepository dependencyRepository;
    private final ElementService elementService;
    private final LibraryElementsService libraryService;
    private final OldContainerUtils oldContainerUtils;

    @Autowired
    public DependencyService(DependencyRepository dependencyRepository, ElementService elementService, LibraryElementsService libraryService, OldContainerUtils oldContainerUtils) {
        this.dependencyRepository = dependencyRepository;
        this.elementService = elementService;
        this.libraryService = libraryService;
        this.oldContainerUtils = oldContainerUtils;
    }

    public Dependency findById(String dependencyId) {
        return (Dependency)this.dependencyRepository.findById((Object)dependencyId).orElseThrow(() -> new EntityNotFoundException(DEPENDENCY_WITH_ID_NOT_FOUND_MESSAGE + dependencyId));
    }

    public List<Dependency> findAllByElementsIDs(List<String> elementIDs) {
        return this.dependencyRepository.findByElementIDs(elementIDs);
    }

    @ChainModification
    public ChainDiff create(String from, String to) {
        ChainElement elementFrom = this.elementService.findById(from);
        ChainElement elementTo = this.elementService.findById(to);
        return this.create(elementFrom, elementTo);
    }

    @ChainModification
    public ChainDiff create(@NonNull ChainElement elementFrom, @NonNull ChainElement elementTo) {
        ChainDiff chainDiff = new ChainDiff();
        Dependency dependency = new Dependency();
        this.validateDependency(elementFrom, elementTo);
        Optional alreadyCreatedOptional = this.dependencyRepository.findByFromAndTo(elementFrom.getId(), elementTo.getId());
        if (alreadyCreatedOptional.isEmpty()) {
            ContainerChainElement elementFromParent = this.oldContainerUtils.getOldContainerParent(this.findFirstNonGroupParent(elementFrom));
            if (elementFromParent != null) {
                this.validateElementToDependencies(elementFromParent, elementFrom, elementTo);
                ArrayList<ChainElement> changedElements = new ArrayList<ChainElement>();
                this.collectAllDependentRootElements(changedElements, elementFromParent.getId(), elementTo);
                changedElements.stream().filter(DistinctByKey.newInstance(AbstractEntity::getId)).map(element -> {
                    this.elementService.checkIfAllowedInContainers(element.getType());
                    element.setParent(elementFromParent);
                    element.setSwimlane(elementFrom.getSwimlane());
                    return this.elementService.save((ChainElement)element);
                }).forEach(chainDiff::addUpdatedElement);
            }
            dependency.setElementFrom(elementFrom);
            dependency.setElementTo(elementTo);
            dependency = (Dependency)this.dependencyRepository.save((Object)dependency);
            elementFrom.addOutputDependency(dependency);
            elementTo.addInputDependency(dependency);
            chainDiff.addCreatedDependency(dependency);
            return chainDiff;
        }
        throw new EntityExistsException("Dependency from " + elementFrom.getId() + " to " + elementTo.getId() + " already exists");
    }

    @ChainModification
    public ChainDiff deleteById(String id) {
        ChainDiff chainDiff = new ChainDiff();
        Dependency dependency = (Dependency)this.dependencyRepository.getReferenceById((Object)id);
        this.dependencyRepository.deleteById((Object)id);
        chainDiff.addRemovedDependency(dependency);
        return chainDiff;
    }

    @ChainModification
    public ChainDiff deleteAllByIds(List<String> ids) {
        ChainDiff chainDiff = new ChainDiff();
        List dependencies = this.dependencyRepository.findAllById(ids);
        this.dependencyRepository.deleteAllById(ids);
        chainDiff.addRemovedDependencies(dependencies);
        return chainDiff;
    }

    private void validateDependency(ChainElement elementFrom, ChainElement elementTo) {
        ElementDescriptor elementDescriptor;
        if ("container".equals(elementFrom.getType()) || "container".equals(elementTo.getType())) {
            throw new DependencyValidationException("Dependency from/to container could not be created");
        }
        if ("swimlane".equals(elementFrom.getType()) || "swimlane".equals(elementTo.getType())) {
            throw new DependencyValidationException("Dependency from/to swimlane could not be created");
        }
        if (elementTo.getParent() != null) {
            long startElementsCount;
            ContainerChainElement elementFromParent = elementFrom.getParent();
            ContainerChainElement elementToParent = elementTo.getParent();
            BiPredicate<ContainerChainElement, ContainerChainElement> sameParents = (fromParent, toParent) -> StringUtils.equals((CharSequence)fromParent.getId(), (CharSequence)toParent.getId()) || this.oldContainerUtils.isOldStyleContainer(fromParent.getType()) && Objects.equals(toParent, fromParent.getParent());
            if (!("container".equals(elementToParent.getType()) || elementFromParent != null && sameParents.test(elementFromParent, elementToParent))) {
                throw new DependencyValidationException("Dependency to container child cannot be created");
            }
            if (!"container".equals(elementToParent.getType()) && (startElementsCount = elementToParent.getElements().stream().filter(element -> element.getInputDependencies().isEmpty()).filter(element -> !Objects.equals(element, elementTo)).count()) < 1L) {
                throw new DependencyValidationException("Dependency to the only one start element cannot be created");
            }
        }
        if ((elementDescriptor = this.libraryService.getElementDescriptor(elementTo)) == null) {
            throw new DependencyValidationException("Element of type " + elementTo.getType() + " not found");
        }
        if (!elementDescriptor.isInputEnabled()) {
            throw new DependencyValidationException("Input dependency disabled for " + elementTo.getType());
        }
        int inputDepCount = elementTo.getInputDependencies().size() + 1;
        Quantity inputQuantity = elementDescriptor.getInputQuantity();
        if (!inputQuantity.test((Object)inputDepCount)) {
            throw new DependencyValidationException(String.format("Only %s input dependencies available for %s", inputQuantity.name(), elementTo.getType()));
        }
    }

    private void validateElementToDependencies(ContainerChainElement fromParent, ChainElement elementFrom, ChainElement elementTo) {
        if (Objects.equals(elementFrom, elementTo) || Objects.equals(fromParent, elementTo.getParent())) {
            return;
        }
        if (fromParent != null && !"container".equals(fromParent.getType()) && elementTo.getInputDependencies().stream().anyMatch(dependency -> !Objects.equals(elementFrom, dependency.getElementFrom()))) {
            throw new DependencyValidationException("Element " + elementTo.getId() + " already has input dependencies with a different parent");
        }
        ContainerChainElement elementFromParent = fromParent;
        do {
            if (!Objects.equals(elementTo, elementFromParent)) continue;
            throw new DependencyValidationException("Dependency to parent cannot be created");
        } while ((elementFromParent = elementFromParent.getParent()) != null);
        elementTo.getOutputDependencies().forEach(dependency -> this.validateElementToDependencies(fromParent, dependency.getElementFrom(), dependency.getElementTo()));
    }

    private void collectAllDependentRootElements(List<ChainElement> elementsToChange, String elementFromParentId, ChainElement elementTo) {
        LinkedList<ChainElement> elementsTo = new LinkedList<ChainElement>();
        elementsTo.offer(elementTo);
        while (!elementsTo.isEmpty()) {
            ChainElement nextElement = (ChainElement)elementsTo.poll();
            ContainerChainElement nextElementParent = nextElement.getParent();
            if (nextElementParent != null && !StringUtils.equals((CharSequence)elementFromParentId, (CharSequence)nextElementParent.getId())) {
                throw new DependencyValidationException("Unable to create a dependency for elements with different parents");
            }
            elementsToChange.add(nextElement);
            ArrayList<Dependency> outputDependencies = new ArrayList<Dependency>(nextElement.getOutputDependencies());
            outputDependencies.addAll(this.oldContainerUtils.extractOldContainerOutputDependencies(nextElement));
            outputDependencies.stream().map(Dependency::getElementTo).filter(outputElement -> !Objects.equals(outputElement, elementTo)).forEach(elementsTo::offer);
        }
    }

    @Nullable
    private ContainerChainElement findFirstNonGroupParent(ChainElement element) {
        ContainerChainElement parent;
        for (parent = element.getParent(); parent != null && "container".equals(parent.getType()); parent = parent.getParent()) {
        }
        return parent;
    }
}

