/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.Collection;
import java.util.Map;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DeploymentService {
    private final RestTemplate restTemplateMS;
    private String runtimeCatalogUrl;

    @Autowired
    public DeploymentService(RestTemplate restTemplateMS, @Value(value="${qip.internal-services.runtime-catalog}") String runtimeCatalogUrl) {
        this.restTemplateMS = restTemplateMS;
        this.runtimeCatalogUrl = "http://" + runtimeCatalogUrl + ":8080";
    }

    public void deleteAllByChainId(String id) {
        this.restTemplateMS.delete(String.format("%s/v1/catalog/chains/%s/deployments", this.runtimeCatalogUrl, id), new Object[0]);
    }

    public Map<String, Collection<ChainRuntimeDeployment>> getAllRuntimeDeployments() {
        ParameterizedTypeReference<Map<String, Collection<ChainRuntimeDeployment>>> responseType = new ParameterizedTypeReference<Map<String, Collection<ChainRuntimeDeployment>>>(){};
        RequestEntity request = RequestEntity.get((String)String.format("%s/v1/catalog/runtime-deployments", this.runtimeCatalogUrl), (Object[])new Object[0]).build();
        return (Map)this.restTemplateMS.exchange(request, (ParameterizedTypeReference)responseType).getBody();
    }
}

