/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.model.dto.system.UsedSystem;
import org.qubership.integration.platform.catalog.model.library.CustomTab;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementProperties;
import org.qubership.integration.platform.catalog.model.library.ElementProperty;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.model.library.PropertyValueType;
import org.qubership.integration.platform.catalog.model.library.Quantity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.SwimlaneChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.ElementBaseService;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementCreationException;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ElementValidationException;
import org.qubership.integration.platform.designtime.catalog.model.ChainDiff;
import org.qubership.integration.platform.designtime.catalog.model.ElementsWithSystemUsage;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.element.CreateElementRequest;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.OrderedElementService;
import org.qubership.integration.platform.designtime.catalog.service.SwimlaneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ElementService
extends ElementBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElementService.class);
    public static final String CONTAINER_TYPE_NAME = "container";
    public static final String CONTAINER_DEFAULT_NAME = "Container";
    private static final String GROUP_ID_PROPERTY = "groupId";
    protected final LibraryElementsService libraryService;
    protected final ChainService chainService;
    protected final SwimlaneService swimlaneService;
    protected final ActionsLogService actionLogger;
    protected final EnvironmentService environmentService;
    protected final AuditingHandler auditingHandler;
    protected final OrderedElementService orderedElementService;
    protected final ElementUtils elementUtils;

    @Autowired
    public ElementService(ElementRepository elementRepository, LibraryElementsService libraryService, @Lazy ChainService chainService, SwimlaneService swimlaneService, ActionsLogService actionLogger, AuditingHandler jpaAuditingHandler, EnvironmentService environmentService, OrderedElementService orderedElementService, ElementUtils elementUtils) {
        super(elementRepository);
        this.libraryService = libraryService;
        this.chainService = chainService;
        this.swimlaneService = swimlaneService;
        this.actionLogger = actionLogger;
        this.auditingHandler = jpaAuditingHandler;
        this.environmentService = environmentService;
        this.orderedElementService = orderedElementService;
        this.elementUtils = elementUtils;
    }

    public List<ChainElement> findBySystemIdAndOperationId(String systemId, String operationId) {
        return this.elementRepository.findAll((Specification & Serializable)(root, query, builder) -> builder.and((Expression)builder.isNotNull((Expression)root.get("chain")), (Expression)builder.equal(builder.function("jsonb_extract_path_text", String.class, new Expression[]{root.get("properties"), builder.literal((Object)"integrationOperationId")}), (Object)operationId)));
    }

    public List<ChainElement> findBySystemIdAndSpecificationGroupId(String systemId, String specificationGroupId) {
        return this.elementRepository.findAll((Specification & Serializable)(root, query, builder) -> builder.and((Expression)builder.isNotNull((Expression)root.get("chain")), (Expression)builder.equal(builder.function("jsonb_extract_path_text", String.class, new Expression[]{root.get("properties"), builder.literal((Object)"integrationSpecificationGroupId")}), (Object)specificationGroupId)));
    }

    public List<ChainElement> findBySystemAndModelId(String systemId, String modelId) {
        return this.elementRepository.findAll((Specification & Serializable)(root, query, builder) -> builder.and((Expression)builder.isNotNull((Expression)root.get("chain")), (Expression)builder.equal(builder.function("jsonb_extract_path_text", String.class, new Expression[]{root.get("properties"), builder.literal((Object)"integrationSpecificationId")}), (Object)modelId)));
    }

    public List<ChainElement> findAllByChainId(String chainId) {
        Chain chain = this.chainService.findById(chainId);
        return chain.getElements();
    }

    public List<ChainElement> findAllBySnapshotId(String snapshotId) {
        return this.elementRepository.findAllBySnapshotId(snapshotId);
    }

    public List<Pair<String, ChainElement>> findAllElementsWithChainNameByElementType(String type) {
        return this.elementRepository.findAllByTypeInAndChainNotNull(Collections.singletonList(type)).stream().map(element -> Pair.of((Object)element.getChain().getName(), (Object)element)).collect(Collectors.toList());
    }

    public Optional<ChainElement> findByOriginalId(String originalId) {
        return this.elementRepository.findByOriginalId(originalId);
    }

    public List<ChainElement> findAllById(List<String> elementIds) {
        return this.elementRepository.findAllById(elementIds);
    }

    public Optional<ChainElement> findByIdAndChainId(String elementId, String chainId) {
        return Optional.ofNullable(this.elementRepository.findByIdAndChainId(elementId, chainId));
    }

    public Optional<SwimlaneChainElement> findSwimlaneWithLockingById(String swimlaneId) {
        return this.elementRepository.findSwimlaneWithLockingById(swimlaneId);
    }

    public Optional<SwimlaneChainElement> findDefaultSwimlaneWithLockingByChainId(String chainId) {
        return this.elementRepository.findDefaultSwimlaneWithLockingByChainId(chainId);
    }

    public Optional<SwimlaneChainElement> findReuseSwimlaneWithLockingByChainId(String chainId) {
        return this.elementRepository.findReuseSwimlaneWithLockingByChainId(chainId);
    }

    public List<String> findAllUsingTypes() {
        return this.elementRepository.findAllGroupByType();
    }

    @ChainModification
    public ChainElement clone(String elementId, String parentId) {
        ChainElement copy = this.recursiveClone(this.findById(elementId));
        this.elementUtils.updateResetOnCopyProperties(copy);
        if (parentId != null) {
            ContainerChainElement parent = (ContainerChainElement)this.findById(parentId, ContainerChainElement.class);
            parent.addChildElement(copy);
            parent.setModifiedWhen(null);
            this.elementRepository.save((Object)((ContainerChainElement)this.auditingHandler.markModified((Object)parent)));
        }
        this.logElementAction(copy, LogOperation.COPY);
        return copy;
    }

    @ChainModification
    private ChainElement recursiveClone(ChainElement root) {
        ChainElement savedCopy = (ChainElement)this.elementRepository.save((Object)root.copyWithoutSnapshot());
        if (root.getModifiedWhen().getTime() == root.getCreatedWhen().getTime()) {
            savedCopy.setCreatedWhen(null);
            savedCopy.setModifiedWhen(null);
        } else {
            savedCopy.setModifiedWhen(Timestamp.valueOf(LocalDateTime.now()));
        }
        if (root instanceof ContainerChainElement) {
            ContainerChainElement container = (ContainerChainElement)savedCopy;
            for (ChainElement element : this.elementRepository.findAllByParentId(root.getId())) {
                container.addChildElement(this.recursiveClone(element));
            }
        }
        return savedCopy;
    }

    @ChainModification
    public ChainDiff create(String chainId, CreateElementRequest createElementRequest) {
        ChainDiff chainDiff = new ChainDiff();
        String parentElementId = createElementRequest.getParentElementId();
        String elementType = createElementRequest.getType();
        if ("swimlane".equals(elementType)) {
            return this.swimlaneService.create(chainId);
        }
        if (parentElementId != null) {
            ChainElement foundParent = this.elementRepository.findByIdAndChainId(parentElementId, chainId);
            if (!(foundParent instanceof ContainerChainElement)) {
                throw new ElementCreationException("Element " + parentElementId + " does not exist in chain " + chainId);
            }
            chainDiff.addCreatedElement(this.create(elementType, (ContainerChainElement)foundParent));
            chainDiff.addUpdatedElement(foundParent);
        } else {
            chainDiff.addCreatedElement(this.create(chainDiff, chainId, createElementRequest));
        }
        return chainDiff;
    }

    protected ChainElement create(ChainDiff chainDiff, String chainId, CreateElementRequest createElementRequest) {
        String elementType = createElementRequest.getType();
        String swimlaneId = createElementRequest.getSwimlaneId();
        Chain chain = this.chainService.findById(chainId);
        this.checkElementParentRestriction(elementType, null);
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(elementType);
        SwimlaneChainElement swimlane = this.findDefaultSwimlaneWithLockingByChainId(chainId).orElse(null);
        if (swimlane != null) {
            if (descriptor.getType() == ElementType.REUSE) {
                swimlane = this.findReuseSwimlaneWithLockingByChainId(chainId).orElseGet(() -> {
                    SwimlaneChainElement reuseGroup = this.swimlaneService.createReuseSwimlane(chain);
                    chainDiff.setCreatedReuseSwimlaneId(reuseGroup.getId());
                    chainDiff.addCreatedElement((ChainElement)reuseGroup);
                    return reuseGroup;
                });
            } else if (swimlaneId != null) {
                swimlane = (SwimlaneChainElement)this.elementRepository.findSwimlaneWithLockingByIdAndChainId(swimlaneId, chainId).orElseThrow(() -> new ElementCreationException("Swimlane " + swimlaneId + " does not exist in chain " + chainId));
                boolean rootParentReuse = Optional.ofNullable(createElementRequest.getParentElementId()).flatMap(parentId -> chain.getElements().stream().filter(element -> StringUtils.equals((CharSequence)parentId, (CharSequence)element.getId())).findFirst()).map(this::findRootParent).map(arg_0 -> ((LibraryElementsService)this.libraryService).getElementDescriptor(arg_0)).map(elementDescriptor -> ElementType.REUSE == elementDescriptor.getType()).orElse(false);
                if (swimlane.isReuseSwimlane() && !rootParentReuse) {
                    throw new ElementCreationException("Only Reuse element can be added to Reuse Swimlane");
                }
            }
        }
        ChainElement newElement = this.create(elementType, swimlane, chain);
        this.logElementAction(newElement, LogOperation.CREATE);
        return newElement;
    }

    @ChainModification
    protected ChainElement create(String elementType, @NonNull ContainerChainElement parentElement) {
        this.checkIfAllowedInContainers(elementType);
        this.checkElementParentRestriction(elementType, parentElement.getType());
        this.checkAddingChildParentRestriction(elementType, parentElement);
        Chain chain = parentElement.getChain();
        ChainElement element = this.create(elementType, parentElement.getSwimlane(), chain);
        parentElement.addChildElement(element);
        if (this.orderedElementService.isOrdered(element)) {
            this.orderedElementService.calculatePriority(parentElement, element);
        }
        this.auditingHandler.markModified((Object)parentElement);
        element.setCreatedWhen(null);
        this.elementRepository.save((Object)parentElement);
        this.logElementAction(element, LogOperation.CREATE);
        return element;
    }

    @ChainModification
    protected ChainElement create(String elementType, SwimlaneChainElement swimlane, Chain chain) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(elementType);
        Object element = descriptor.isContainer() ? new ContainerChainElement() : new ChainElement();
        element.setName(descriptor.getTitle());
        element.setType(elementType);
        element.setChain(chain);
        element.setSwimlane(swimlane);
        element.setProperties(this.createPropertiesMap(descriptor.getProperties(), element.getId(), chain.getId()));
        if (element instanceof ContainerChainElement) {
            ContainerChainElement container = element = (ChainElement)this.elementRepository.save(element);
            for (Map.Entry childDefinition : descriptor.getAllowedChildren().entrySet()) {
                String libraryElement = (String)childDefinition.getKey();
                Quantity libraryElementQuantity = (Quantity)childDefinition.getValue();
                ElementDescriptor childTypeDefinition = this.libraryService.getElementDescriptor(libraryElement);
                if (childTypeDefinition.isDeprecated() && !descriptor.isDeprecated()) continue;
                int elementNumber = libraryElementQuantity == Quantity.TWO_OR_MANY ? 2 : 1;
                for (int i = 0; i < elementNumber; ++i) {
                    this.create(libraryElement, container);
                }
            }
        }
        element = (ChainElement)this.elementRepository.save(element);
        return element;
    }

    protected ChainElement findRootParent(@NonNull ChainElement element) {
        ChainElement parentElement = element;
        while (parentElement.getParent() != null) {
            parentElement = parentElement.getParent();
        }
        return parentElement;
    }

    protected void checkElementParentRestriction(String elementType, String parentElementType) {
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(elementType);
        if (elementDescriptor == null) {
            throw new ElementValidationException("Element of type " + elementType + " cannot be a child");
        }
        if (elementDescriptor.getParentRestriction() == null || elementDescriptor.getParentRestriction().isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)parentElementType) || elementDescriptor.getParentRestriction().stream().noneMatch(parentElType -> parentElType.equals(parentElementType))) {
            throw new ElementValidationException("Element " + elementType + " should be only inside parent element: " + StringUtils.join((Iterable)elementDescriptor.getParentRestriction(), (String)", "));
        }
    }

    protected void checkAddingChildParentRestriction(String childElementType, ContainerChainElement parent) {
        ElementDescriptor parentDescriptor = this.libraryService.getElementDescriptor(parent.getType());
        if (parentDescriptor != null) {
            Map childrenMap = parentDescriptor.getAllowedChildren();
            ElementDescriptor childElementDescriptor = this.libraryService.getElementDescriptor(childElementType);
            if (MapUtils.getObject((Map)childrenMap, (Object)childElementType) == null && !childElementDescriptor.isInputEnabled()) {
                throw new ElementValidationException("Element with disabled input cannot be inside a parent element " + parent.getType());
            }
            if (MapUtils.isEmpty((Map)childrenMap)) {
                return;
            }
            Quantity elementCount = (Quantity)childrenMap.get(childElementType);
            if (elementCount == null) {
                throw new ElementValidationException("Element " + childElementType + " is not allowed to be inside parent element " + parent.getType());
            }
            long childCount = parent.getElements().stream().filter(child -> child.getType().equals(childElementType)).count();
            if (!elementCount.test((Object)((int)childCount + 1))) {
                throw new ElementValidationException("Number of " + childElementType + " elements inside parent " + parent.getType() + " element exceed limit");
            }
        }
    }

    protected void checkIfAllowedInContainers(String elementType) {
        Optional.ofNullable(this.libraryService.getElementDescriptor(elementType)).filter(descriptor -> !descriptor.isAllowedInContainers()).ifPresent(descriptor -> {
            throw new ElementValidationException("The " + descriptor.getName() + " element cannot be inside a container");
        });
    }

    @ChainModification
    protected ContainerChainElement deleteElementFromParent(ChainElement child, boolean isImportProcess) {
        ContainerChainElement parent = child.getParent();
        if (parent == null) {
            return null;
        }
        parent.setModifiedWhen(null);
        parent = (ContainerChainElement)this.elementRepository.save((Object)((ContainerChainElement)this.auditingHandler.markModified((Object)parent)));
        if (!isImportProcess) {
            Map childrenMap;
            ElementDescriptor parentDescriptor = this.libraryService.getElementDescriptor(parent.getType());
            if (parentDescriptor != null && MapUtils.isNotEmpty((Map)(childrenMap = parentDescriptor.getAllowedChildren())) && childrenMap.get(child.getType()) != null) {
                Quantity elementCount = (Quantity)childrenMap.get(child.getType());
                long childCount = parent.getElements().stream().filter(c -> c.getType().equals(child.getType())).count();
                if (elementCount == Quantity.ONE && childCount == 1L || elementCount == Quantity.ONE_OR_MANY && childCount == 1L || elementCount == Quantity.TWO_OR_MANY && childCount == 2L) {
                    throw new ElementValidationException("Number of " + child.getType() + " elements inside parent " + parent.getType() + " element can't be lowered");
                }
            }
            parent.getElements().remove(child);
        }
        return parent;
    }

    protected Map<String, Object> createPropertiesMap(ElementProperties properties, String elementId, String chainId) {
        return new HashMap<String, Object>(properties.getAll().stream().filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getDefaultValue())).collect(Collectors.toMap(ElementProperty::getName, prop -> PropertyValueType.STRING.equals((Object)prop.getType()) ? ElementUtils.replaceDefaultValuePlaceholders((String)prop.getDefaultValue(), (String)elementId, (String)chainId) : prop.defaultValue())));
    }

    @ChainModification
    public ChainElement changeParent(ChainElement element, String newParentId) {
        this.checkIfAllowedInContainers(element.getType());
        ContainerChainElement parent = newParentId != null ? (ContainerChainElement)this.findById(newParentId, ContainerChainElement.class) : null;
        ContainerChainElement oldParent = element.getParent();
        this.auditingHandler.markModified((Object)oldParent);
        oldParent.removeChildElement(element);
        if (parent != null) {
            parent.addChildElement(element);
            this.auditingHandler.markModified((Object)parent);
        }
        return element;
    }

    @ChainModification
    public ChainElement save(ChainElement element) {
        this.auditingHandler.markModified((Object)element);
        return (ChainElement)this.elementRepository.save((Object)element);
    }

    @ChainModification
    public List<ChainElement> saveAll(List<ChainElement> elements) {
        elements.forEach(arg_0 -> ((AuditingHandler)this.auditingHandler).markModified(arg_0));
        return this.elementRepository.saveAll(elements);
    }

    public void deleteAll(Collection<ChainElement> elements) {
        this.elementRepository.deleteAll(elements);
    }

    @ChainModification
    public ChainDiff updateRelativeProperties(ChainElement element, Map<String, Object> newProperties) {
        ChainDiff chainDiff = new ChainDiff();
        if (this.orderedElementService.isOrdered(element)) {
            this.orderedElementService.extractPriorityNumber(element.getType(), newProperties).ifPresent(newPriorityNumber -> {
                ChainDiff newChainDiff = this.orderedElementService.changePriority(element.getParent(), element, (Integer)newPriorityNumber);
                chainDiff.merge(newChainDiff);
            });
        }
        this.saveAll(chainDiff.getUpdatedElements());
        return chainDiff;
    }

    @ChainModification
    public ChainDiff deleteAllByIdsAndUpdateUnsaved(List<String> ids) {
        ChainDiff chainDiff = new ChainDiff();
        for (String id : ids) {
            chainDiff.merge(this.deleteByIdAndUpdateUnsaved(id));
        }
        return chainDiff;
    }

    @ChainModification
    public ChainDiff deleteByIdAndUpdateUnsaved(String id) {
        return this.deleteById(id, false);
    }

    private ChainDiff deleteById(String id, boolean isImportProcess) {
        ChainDiff chainDiff = new ChainDiff();
        Optional elementOptional = this.elementRepository.findById((Object)id);
        if (elementOptional.isPresent()) {
            ContainerChainElement parentElement;
            ChainElement element = (ChainElement)elementOptional.get();
            if (element instanceof SwimlaneChainElement) {
                return this.swimlaneService.delete(id);
            }
            ArrayList<ChainElement> elements = new ArrayList<ChainElement>();
            elements.add(element);
            if (this.orderedElementService.isOrdered(element)) {
                ChainDiff orderedChainDiff = this.orderedElementService.removeOrderedElement(element.getParent(), element);
                this.saveAll(orderedChainDiff.getUpdatedElements());
                chainDiff.merge(orderedChainDiff);
            }
            if (element instanceof ContainerChainElement) {
                ContainerChainElement containerElement = (ContainerChainElement)element;
                this.collectAllNestedElements(elements, containerElement);
            }
            if ((parentElement = this.deleteElementFromParent(element, isImportProcess)) != null) {
                chainDiff.addUpdatedElement((ChainElement)parentElement);
            }
            chainDiff.addRemovedElements(elements);
            Optional.ofNullable(this.libraryService.getElementDescriptor(element)).filter(ElementDescriptor::isReferencedByAnotherElement).ifPresent(descriptor -> this.deleteElementReferences(chainDiff, element));
            for (ChainElement elementToRemove : elements) {
                chainDiff.addRemovedDependencies(elementToRemove.getInputDependencies());
                chainDiff.addRemovedDependencies(elementToRemove.getOutputDependencies());
            }
            this.elementRepository.deleteAll(elements);
            this.logElementsAction(elements, LogOperation.DELETE);
        }
        return chainDiff;
    }

    private void collectAllNestedElements(List<ChainElement> elements, ContainerChainElement container) {
        elements.addAll(container.getElements());
        for (ChainElement element : container.getElements()) {
            if (!(element instanceof ContainerChainElement)) continue;
            this.collectAllNestedElements(elements, (ContainerChainElement)element);
        }
    }

    private void deleteElementReferences(ChainDiff chainDiff, ChainElement referencedElement) {
        String chainId = Optional.ofNullable(referencedElement.getChain()).map(AbstractEntity::getId).orElse(null);
        Map elementDescriptors = this.libraryService.getElementsWithReferenceProperties();
        List elements = this.elementRepository.findAllByChainIdAndTypeIn(chainId, elementDescriptors.keySet());
        ArrayList<ChainElement> elementsToUpdate = new ArrayList<ChainElement>();
        for (ChainElement element : elements) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)elementDescriptors.get(element.getType());
            List referenceProperties = elementDescriptor.getReferenceProperties();
            boolean elementUpdated = false;
            for (ElementProperty referenceProperty : referenceProperties) {
                String propertyValue = element.getPropertyAsString(referenceProperty.getName());
                if (!StringUtils.equals((CharSequence)propertyValue, (CharSequence)referencedElement.getId())) continue;
                element.getProperties().remove(referenceProperty.getName());
                elementUpdated = true;
            }
            if (!elementUpdated) continue;
            elementsToUpdate.add(element);
        }
        if (!elementsToUpdate.isEmpty()) {
            chainDiff.addUpdatedElements(this.saveAll(elementsToUpdate));
        }
    }

    @ChainModification
    public ChainElement group(String chainId, List<String> elementsId) throws IllegalArgumentException {
        Chain chain = this.chainService.findById(chainId);
        ContainerChainElement group = ((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)ContainerChainElement.builder().name(CONTAINER_DEFAULT_NAME)).type(CONTAINER_TYPE_NAME)).chain(chain)).elements(new ArrayList()).properties(new HashMap())).build();
        List elements = this.elementRepository.findAllById(elementsId);
        if (elements.size() > 0) {
            long elementsWithParent = elements.stream().filter(it -> it.getParent() != null).count();
            if (elementsWithParent > 0L) {
                throw new ElementValidationException("Elements with non-null parent cannot be grouped");
            }
            elements.forEach(element -> this.checkIfAllowedInContainers(element.getType()));
            group.addChildrenElements((Collection)elements);
            group.setSwimlane(((ChainElement)elements.get(0)).getSwimlane());
        }
        group = (ContainerChainElement)this.elementRepository.saveEntity((Object)group);
        this.logElementAction((ChainElement)group, LogOperation.CREATE);
        this.logElementsAction(elements, LogOperation.GROUP);
        return group;
    }

    @ChainModification
    public List<ChainElement> ungroup(String groupId) {
        ContainerChainElement group = (ContainerChainElement)this.findById(groupId, ContainerChainElement.class);
        if (StringUtils.equals((CharSequence)group.getType(), (CharSequence)CONTAINER_TYPE_NAME)) {
            List children = group.getElements();
            children.forEach(child -> child.setParent(null));
            children = this.elementRepository.saveAll((Iterable)children);
            this.elementRepository.delete((Object)group);
            this.logElementAction((ChainElement)group, LogOperation.DELETE);
            this.logElementsAction(children, LogOperation.UNGROUP);
            return children;
        }
        throw new ElementValidationException("Element with id = " + groupId + " is not a group");
    }

    private void logElementsAction(List<ChainElement> elements, LogOperation operation) {
        for (ChainElement element : elements) {
            this.logElementAction(element, operation);
        }
    }

    private void logElementAction(ChainElement element, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.ELEMENT).entityId(element.getId()).entityName(element.getName()).parentType(element.getChain() == null ? null : EntityType.CHAIN).parentId(element.getChain() == null ? null : element.getChain().getId()).parentName(element.getChain() == null ? null : element.getChain().getName()).operation(operation).build());
    }

    public List<UsedSystem> getUsedSystemIdsByChainIds(List<String> chainIds) {
        ArrayList<UsedSystem> usedSystems = new ArrayList<UsedSystem>();
        ArrayList<String> elementTypes = new ArrayList<String>();
        for (ElementsWithSystemUsage element : ElementsWithSystemUsage.values()) {
            elementTypes.add(element.getElementName());
        }
        List elements = this.elementRepository.findAllByTypeInAndChainNotNull(elementTypes);
        for (String chainId : chainIds) {
            for (ChainElement chainElement : elements) {
                UsedSystem usedSystem;
                if (chainElement.getChain() == null || !Objects.equals(chainElement.getChain().getId(), chainId)) continue;
                String systemId = (String)chainElement.getProperties().get("integrationSystemId");
                String specificationId = (String)chainElement.getProperties().get("integrationSpecificationId");
                if (StringUtils.isBlank((CharSequence)systemId)) continue;
                if (usedSystems.stream().noneMatch(system -> system.getSystemId().equals(systemId))) {
                    usedSystem = new UsedSystem(systemId, new ArrayList());
                    usedSystems.add(usedSystem);
                }
                if (StringUtils.isBlank((CharSequence)specificationId) || (usedSystem = (UsedSystem)usedSystems.stream().filter(system -> system.getSystemId().equals(systemId)).findFirst().orElse(null)) == null || usedSystem.getUsedSystemModelIds().contains(specificationId)) continue;
                usedSystem.getUsedSystemModelIds().add(specificationId);
            }
        }
        return usedSystems;
    }

    public List<UsedSystem> getAllUsedSystemIds() {
        ArrayList<String> elementTypes = new ArrayList<String>();
        for (ElementsWithSystemUsage element : ElementsWithSystemUsage.values()) {
            elementTypes.add(element.getElementName());
        }
        List elements = this.elementRepository.findAllByTypeInAndChainNotNull(elementTypes);
        return this.getUsedSystemsFromElements(elements);
    }

    public boolean isElementDeprecated(ChainElement chainElement) {
        return Optional.ofNullable(this.libraryService.getElementDescriptor(chainElement)).map(ElementDescriptor::isDeprecated).orElse(false);
    }

    public boolean isElementUnsupported(ChainElement chainElement) {
        return Optional.ofNullable(this.libraryService.getElementDescriptor(chainElement)).map(ElementDescriptor::isUnsupported).orElse(false);
    }

    public void validateElementProperties(ChainElement element) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(element);
        if (descriptor == null) {
            return;
        }
        for (ElementProperty property : descriptor.getProperties().getAll()) {
            if (!this.elementUtils.isMandatoryPropertyPresent(property, element)) {
                throw new ElementValidationException("Value not found for " + property.getName());
            }
            if (property.getMask() == null) continue;
            String propertyValue = element.getPropertyAsString(property.getName());
            if (propertyValue == null) {
                throw new ElementValidationException("Invalid Value for " + property.getName());
            }
            Matcher matcher = property.getMask().matcher(propertyValue);
            if (matcher.find()) continue;
            throw new ElementValidationException("Invalid Value for " + property.getName());
        }
        for (CustomTab customTab : descriptor.getCustomTabs()) {
            if (customTab.getValidation() == null || customTab.getValidation().arePropertiesValid(element.getProperties())) continue;
            throw new ElementValidationException("Some mandatory properties are missing on tab " + customTab.getName());
        }
    }

    private List<UsedSystem> getUsedSystemsFromElements(List<ChainElement> elements) {
        ArrayList<UsedSystem> usedSystems = new ArrayList<UsedSystem>();
        for (ChainElement chainElement : elements) {
            UsedSystem usedSystem;
            if (chainElement.getChain() == null) continue;
            String systemId = (String)chainElement.getProperties().get("integrationSystemId");
            String specificationId = (String)chainElement.getProperties().get("integrationSpecificationId");
            if (StringUtils.isBlank((CharSequence)systemId)) continue;
            if (usedSystems.stream().noneMatch(system -> system.getSystemId().equals(systemId))) {
                usedSystem = new UsedSystem(systemId, new ArrayList());
                usedSystems.add(usedSystem);
            }
            if (StringUtils.isBlank((CharSequence)specificationId) || (usedSystem = (UsedSystem)usedSystems.stream().filter(system -> system.getSystemId().equals(systemId)).findFirst().orElse(null)) == null || usedSystem.getUsedSystemModelIds().contains(specificationId)) continue;
            usedSystem.getUsedSystemModelIds().add(specificationId);
        }
        return usedSystems;
    }
}

