/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.MaskedField;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.MaskedFieldRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.configuration.aspect.ChainModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MaskedFieldsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaskedFieldsService.class);
    private static final String MASKED_FIELD_WITH_ID_NOT_FOUND_MESSAGE = "Can't find masked field with id: ";
    private final MaskedFieldRepository maskedRepository;
    private final ActionsLogService actionLogger;

    @Autowired
    public MaskedFieldsService(MaskedFieldRepository maskedRepository, ActionsLogService actionLogger) {
        this.maskedRepository = maskedRepository;
        this.actionLogger = actionLogger;
    }

    public MaskedField findById(String fieldId) {
        return (MaskedField)this.maskedRepository.findById((Object)fieldId).orElseThrow(() -> new EntityNotFoundException(MASKED_FIELD_WITH_ID_NOT_FOUND_MESSAGE + fieldId));
    }

    @ChainModification
    public MaskedField delete(String fieldId) {
        MaskedField field = this.findById(fieldId);
        this.maskedRepository.deleteById((Object)fieldId);
        this.logMaskedFieldsAction(field, LogOperation.DELETE);
        return field;
    }

    @ChainModification
    public void deleteAllByIds(List<String> ids) {
        List maskedFields = this.maskedRepository.findAllById(ids);
        this.maskedRepository.deleteAllByIdInBatch(ids);
        maskedFields.forEach(maskedField -> this.logMaskedFieldsAction((MaskedField)maskedField, LogOperation.DELETE));
    }

    @ChainModification
    public MaskedField create(MaskedField maskedField) {
        maskedField = this.createOrUpdate(maskedField);
        this.logMaskedFieldsAction(maskedField, LogOperation.CREATE);
        return maskedField;
    }

    @ChainModification
    public MaskedField update(MaskedField maskedField) {
        maskedField = this.createOrUpdate(maskedField);
        this.logMaskedFieldsAction(maskedField, LogOperation.UPDATE);
        return maskedField;
    }

    public MaskedField save(MaskedField maskedField) {
        return (MaskedField)this.maskedRepository.save((Object)maskedField);
    }

    private MaskedField createOrUpdate(MaskedField maskedField) {
        Optional existingEntity = this.maskedRepository.findFirstByChainIdAndName(maskedField.getChain().getId(), maskedField.getName());
        if (existingEntity.isPresent() && !((MaskedField)existingEntity.get()).getId().equals(maskedField.getId())) {
            throw new EntityExistsException("Field with name " + maskedField.getName() + " already exist");
        }
        return (MaskedField)this.maskedRepository.save((Object)maskedField);
    }

    private void logMaskedFieldsAction(MaskedField field, LogOperation operation) {
        this.actionLogger.logAction(ActionLog.builder().entityType(EntityType.MASKED_FIELD).entityId(field.getId()).entityName(field.getName()).parentType(field.getChain() == null ? null : EntityType.CHAIN).parentId(field.getChain() == null ? null : field.getChain().getId()).parentName(field.getChain() == null ? null : field.getChain().getName()).operation(operation).build());
    }
}

