/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.repository.operations.OperationRepository;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class OperationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationService.class);
    private static final String OPERATION_WITH_ID_NOT_FOUND_MESSAGE = "Can't find operation with id ";
    private final OperationRepository operationRepository;
    private final ObjectMapper objectMapper;
    private final ChainService chainService;

    @Autowired
    public OperationService(OperationRepository operationRepository, @Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper, @Lazy ChainService chainService) {
        this.operationRepository = operationRepository;
        this.objectMapper = objectMapper;
        this.chainService = chainService;
    }

    public List<Operation> getOperationsByModel(String modelId, int offset, int count, String prefixFilter, List<String> sortColumns) {
        return this.getOperations(modelId, offset, count, prefixFilter, sortColumns);
    }

    private List<Operation> getOperations(String modelId, int offset, int limit, String prefixFilter, List<String> sortColumns) {
        if (offset < 0 || limit < 0) {
            return Collections.emptyList();
        }
        boolean filterPresent = (prefixFilter = prefixFilter.stripLeading().stripTrailing()).length() > 0;
        List<String> query = Arrays.asList(prefixFilter.split("\\s+"));
        List operations = limit > 0 ? (filterPresent ? this.operationRepository.getOperationsByFilter(modelId, query, sortColumns, offset, limit) : this.operationRepository.getOperations(modelId, sortColumns, offset, limit)) : (filterPresent ? this.operationRepository.getOperationsByFilter(modelId, query, sortColumns) : this.operationRepository.getOperations(modelId, sortColumns));
        return operations.stream().peek(this::enrichOperationWithChains).collect(Collectors.toList());
    }

    public Operation getOperation(String operationId) {
        return (Operation)this.operationRepository.findById((Object)operationId).orElseThrow(() -> new EntityNotFoundException(OPERATION_WITH_ID_NOT_FOUND_MESSAGE + operationId));
    }

    public Operation getOperationLight(String operationId) {
        Operation operation = this.getOperation(operationId);
        Map<String, JsonNode> requestLight = operation.getRequestSchema().keySet().stream().map(key -> new ImmutablePair(key, (Object)this.objectMapper.createObjectNode())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        operation.setRequestSchema(requestLight);
        Map<String, JsonNode> responsesLight = operation.getResponseSchemas().keySet().stream().map(key -> {
            Iterator fields = ((JsonNode)operation.getResponseSchemas().get(key)).fields();
            HashMap fieldsMap = new HashMap();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                fieldsMap.put(field.getKey(), this.objectMapper.createObjectNode());
            }
            JsonNode subNode = (JsonNode)this.objectMapper.convertValue(fieldsMap, JsonNode.class);
            return new ImmutablePair(key, (Object)subNode);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        operation.setResponseSchemas(responsesLight);
        return operation;
    }

    public String getSpecification(String operationId) {
        Operation operation = this.getOperation(operationId);
        return operation.getSpecification().toString();
    }

    public JsonNode getRequestSchema(String operationId, String contentType) {
        Operation operation = this.getOperation(operationId);
        return (JsonNode)operation.getRequestSchema().get(contentType);
    }

    public JsonNode getResponseSchema(String operationId, String contentType, String responseCode) {
        Operation operation = this.getOperation(operationId);
        System.out.print(((JsonNode)operation.getResponseSchemas().get(responseCode)).path(contentType));
        return ((JsonNode)operation.getResponseSchemas().get(responseCode)).path(contentType);
    }

    private void enrichOperationWithChains(Operation operation) {
        List<Chain> chains = this.chainService.findBySystemAndOperationId(null, operation.getId());
        operation.setChains(chains);
    }
}

