/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.system.SystemModelSource;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractLabel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SpecificationGroup;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModelLabel;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemModelLabelsRepository;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemModelRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.catalog.service.SystemModelBaseService;
import org.qubership.integration.platform.catalog.service.codegen.SystemModelCodeGenerator;
import org.qubership.integration.platform.catalog.service.compiler.CompilerService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.SpecificationDeleteException;
import org.qubership.integration.platform.designtime.catalog.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemModelService
extends SystemModelBaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemModelService.class);
    private final ChainService chainService;

    @Autowired
    public SystemModelService(SystemModelRepository systemModelRepository, ActionsLogService actionLogger, List<SystemModelCodeGenerator> codeGenerators, CompilerService compilerService, @Lazy ChainService chainService, SystemModelLabelsRepository systemModelLabelsRepository) {
        super(systemModelRepository, codeGenerators, compilerService, systemModelLabelsRepository, actionLogger);
        this.chainService = chainService;
    }

    public SystemModel getLatestSystemModel(String systemId) {
        return this.systemModelRepository.findFirstBySpecificationGroupSystemIdOrderByCreatedWhenDesc(systemId);
    }

    public SystemModel getLastDiscoveredSystemModelInGroup(String specificationGroupId) {
        return this.systemModelRepository.findFirstBySpecificationGroupIdAndSourceEqualsOrderByCreatedWhenDesc(specificationGroupId, SystemModelSource.DISCOVERED);
    }

    public List<SystemModel> getSystemModelsBySystemId(String systemId) {
        return this.systemModelRepository.findSystemModelsBySpecificationGroupSystemId(systemId).stream().peek(this::enrichSystemModelWithChains).collect(Collectors.toList());
    }

    public List<SystemModel> getSystemModelsBySpecificationGroupId(String specificationGroupId) {
        return super.getSystemModelsBySpecificationGroupId(specificationGroupId).stream().peek(this::enrichSystemModelWithChains).collect(Collectors.toList());
    }

    public SystemModel getSystemModelByVersionAndSpecificationGroupId(String specificationGroupId, String version) {
        return this.systemModelRepository.findFirstBySpecificationGroupIdAndVersion(specificationGroupId, version);
    }

    @Transactional
    public SystemModel partiallyUpdate(SystemModel newModel) {
        SystemModel persistedModel = this.getSystemModel(newModel.getId());
        if (newModel.getName() != null) {
            persistedModel.setName(newModel.getName());
        }
        if (newModel.getVersion() != null) {
            persistedModel.setVersion(newModel.getVersion());
        }
        this.replaceLabels(persistedModel, newModel.getLabels());
        SystemModel model = (SystemModel)this.systemModelRepository.save((Object)persistedModel);
        this.logModelAction(model, model.getSpecificationGroup(), LogOperation.UPDATE);
        return model;
    }

    private void replaceLabels(SystemModel specification, Set<SystemModelLabel> newLabels) {
        if (newLabels == null) {
            return;
        }
        Set<SystemModelLabel> finalNewLabels = newLabels;
        SystemModel finalSpecification = specification;
        finalNewLabels.forEach(label -> label.setSpecification(finalSpecification));
        specification.getLabels().removeIf(l -> !l.isTechnical() && !finalNewLabels.stream().map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        finalNewLabels.removeIf(l -> l.isTechnical() || finalSpecification.getLabels().stream().filter(lab -> !lab.isTechnical()).map(AbstractLabel::getName).collect(Collectors.toSet()).contains(l.getName()));
        newLabels = new HashSet<SystemModelLabel>(this.systemModelLabelsRepository.saveAll(finalNewLabels));
        specification.addLabels(newLabels);
    }

    public void deleteSystemModel(SystemModel model) {
        if (!model.isDeprecated()) {
            throw new SpecificationDeleteException("Specification must be deprecated");
        }
        if (this.chainService.isSystemModelUsedByChain(model.getId())) {
            throw new SpecificationDeleteException("Specification used by one or more chains");
        }
        SpecificationGroup specificationGroup = model.getSpecificationGroup();
        specificationGroup.removeSystemModel(model);
        this.systemModelRepository.delete((Object)model);
        this.logModelAction(model, specificationGroup, LogOperation.DELETE);
    }

    private void enrichSystemModelWithChains(SystemModel model) {
        List<Chain> chains = this.chainService.findBySystemAndModelId(null, model.getId());
        model.setChains(chains);
        for (Operation operation : model.getOperations()) {
            List operationChains = chains.stream().flatMap(operationChain -> operationChain.getElements().stream()).filter(chainElement -> StringUtils.equals((CharSequence)operation.getId(), (CharSequence)chainElement.getPropertyAsString("integrationOperationId"))).map(ChainElement::getChain).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            operation.setChains(operationChains);
        }
    }
}

