/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.model.chain.element.UsedProperty;
import org.qubership.integration.platform.catalog.model.chain.element.UsedPropertyElement;
import org.qubership.integration.platform.catalog.model.chain.element.UsedPropertyElementOperation;
import org.qubership.integration.platform.catalog.model.chain.element.UsedPropertySource;
import org.qubership.integration.platform.catalog.model.chain.element.UsedPropertyType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.repository.chain.ElementRepository;
import org.qubership.integration.platform.designtime.catalog.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UsedPropertiesAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsedPropertiesAnalyzer.class);
    private static final Pattern GROOVY_GET_HEADERS_PATTERN = Pattern.compile("exchange\\.(message|getMessage\\(\\))\\.(headers|getHeader\\(|getHeaders\\(\\))((\\[(['\"]))|(\\.?((get\\(([\"']))|([\"'])?)))([a-zA-Z0-9_.\\-]+)(?!([^\\n\\r]*[=(]))", 2);
    public static final int[] GROOVY_GET_HEADER_GROUPS = new int[]{11};
    private static final Pattern GROOVY_SET_HEADERS_PATTERN = Pattern.compile("exchange\\.(message|getMessage\\(\\))\\.((headers([\\[.]['\"]?)([a-zA-Z0-9_.\\-]+)(['\"]]?)?\\s+=)|(setHeader\\(['\"]([a-zA-Z0-9_.\\-]+)(['\")]?))|(((getHeaders\\(\\)|headers)\\.remove|removeHeader)(\\(['\"])([a-zA-Z0-9_.\\-]+)))", 2);
    public static final int[] GROOVY_SET_HEADER_GROUPS = new int[]{5, 8, 14};
    private static final Pattern GROOVY_GET_PROPERTIES_PATTERN = Pattern.compile("exchange\\.((properties|getProperty)((([\\[(])|(\\.))['\"]?)([a-zA-Z0-9_.\\-]+)(?!([^\\n\\r]*[=(])))", 2);
    public static final int[] GROOVY_GET_PROPERTIES_GROUPS = new int[]{7};
    private static final Pattern GROOVY_SET_PROPERTIES_PATTERN = Pattern.compile("exchange\\.((properties[\\[.]['\"]?([a-zA-Z0-9_.\\-]+)(['\"]]?)?\\s+=)|(setProperty\\(['\"]([a-zA-Z0-9_.\\-]+)['\"]\\)?)|(properties\\.remove|getProperties\\(\\)\\.remove|removeProperty)(\\(['\"])([a-zA-Z0-9_.\\-]+))", 2);
    public static final int[] GROOVY_SET_PROPERTIES_GROUPS = new int[]{3, 6, 9};
    private static final Pattern PROPS_SIMPLE_PATTERN = Pattern.compile("\\$\\{exchangeProperty((\\.([a-zA-Z0-9_\\-]+))|([.\\[]'?([a-zA-Z0-9_.\\-]+)))[^}]*}", 2);
    public static final int[] EX_PROP_GROUPS = new int[]{3, 5};
    private static final Pattern HEADERS_SIMPLE_PATTERN = Pattern.compile("\\$\\{headera?s?((\\.([a-zA-Z0-9_\\-]+))|([.\\[(]'?([a-zA-Z0-9_.\\-]+)))[^}]*}", 2);
    public static final int[] EX_HEADER_GROUPS = new int[]{3, 5};
    private static final Set<String> ELEMENTS_WITH_SCRIPT = Set.of("script", "service-call", "http-trigger");
    private static final Set<String> ELEMENTS_WITH_MAPPER = Set.of("mapper-2", "service-call", "http-trigger");
    private static final Set<String> EXCLUDE_MAPPER_ELEMENTS = Set.of("mapper", "mapper-2", "service-call", "http-trigger");
    public static final String MAPPING_DESCRIPTION = "mappingDescription";
    private final ElementRepository elementRepository;

    @Autowired
    public UsedPropertiesAnalyzer(ElementRepository elementRepository) {
        this.elementRepository = elementRepository;
    }

    public List<UsedProperty> getUsedProperties(String chainId) {
        List chainElements = this.elementRepository.findAllByChainId(chainId);
        HashMap<String, UsedProperty> usedProperties = new HashMap<String, UsedProperty>();
        for (ChainElement chainElement : chainElements) {
            this.findUsedProperties(chainElement, chainElement.getProperties(), usedProperties);
            this.findUsedPropertiesInScript(chainElement, usedProperties);
            this.findUsedPropertiesInMapper(chainElement, usedProperties);
            this.findUsedPropertiesInHeaderModification(chainElement, usedProperties);
        }
        return new ArrayList<UsedProperty>(usedProperties.values());
    }

    private void findUsedPropertiesInMapper(ChainElement element, Map<String, UsedProperty> usedProperties) {
        String elementType = element.getType();
        if (ELEMENTS_WITH_MAPPER.contains(elementType)) {
            Map elementProperties = element.getProperties();
            ArrayList mappingDescription = new ArrayList();
            switch (elementType) {
                case "mapper-2": {
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)elementProperties, value -> mappingDescription.add((Map)value), MAPPING_DESCRIPTION);
                    break;
                }
                case "service-call": {
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)elementProperties, value -> mappingDescription.add((Map)value), "after", MAPPING_DESCRIPTION);
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)elementProperties, value -> mappingDescription.add((Map)value), "before", MAPPING_DESCRIPTION);
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)elementProperties, value -> mappingDescription.add((Map)value), "handlerContainer", MAPPING_DESCRIPTION);
                    break;
                }
                case "http-trigger": {
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)elementProperties, value -> mappingDescription.add((Map)value), "handlerContainer", MAPPING_DESCRIPTION);
                }
            }
            if (!mappingDescription.isEmpty()) {
                for (Map map : mappingDescription) {
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)map, this.mapperTraversalCallback(usedProperties, UsedPropertiesAnalyzer.buildUsedPropertyElement(element, UsedPropertyElementOperation.GET), UsedPropertySource.HEADER), "source", "headers");
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)map, this.mapperTraversalCallback(usedProperties, UsedPropertiesAnalyzer.buildUsedPropertyElement(element, UsedPropertyElementOperation.GET), UsedPropertySource.EXCHANGE_PROPERTY), "source", "properties");
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)map, this.mapperTraversalCallback(usedProperties, UsedPropertiesAnalyzer.buildUsedPropertyElement(element, UsedPropertyElementOperation.SET), UsedPropertySource.HEADER), "target", "headers");
                    MapUtils.deepMapTraversalSafe((Map<String, Object>)map, this.mapperTraversalCallback(usedProperties, UsedPropertiesAnalyzer.buildUsedPropertyElement(element, UsedPropertyElementOperation.SET), UsedPropertySource.EXCHANGE_PROPERTY), "target", "properties");
                }
            }
        }
    }

    @NotNull
    private static UsedPropertyElement buildUsedPropertyElement(ChainElement element, UsedPropertyElementOperation operation) {
        UsedPropertyElement usedSrcElementHeader = UsedPropertyElement.builder().id(element.getId()).name(element.getName()).type(element.getType()).build();
        usedSrcElementHeader.getOperations().add(operation);
        return usedSrcElementHeader;
    }

    @NotNull
    private Consumer<Object> mapperTraversalCallback(Map<String, UsedProperty> usedProperties, UsedPropertyElement usedElement, UsedPropertySource usedPropertySource) {
        return headers -> {
            if (headers instanceof Collection) {
                Collection headersList = (Collection)headers;
                this.addMapperProperty(usedProperties, headersList, usedElement, usedPropertySource);
            }
        };
    }

    private void addMapperProperty(Map<String, UsedProperty> usedProperties, Collection<?> headersList, UsedPropertyElement usedSrcElement, UsedPropertySource usedPropertySource) {
        for (Object entry : headersList) {
            if (!(entry instanceof Map)) continue;
            Map map1 = (Map)entry;
            String name = (String)map1.get("name");
            Map type = (Map)map1.get("type");
            String typeName = (String)type.get("name");
            if (!StringUtils.isNotEmpty((CharSequence)name) || !StringUtils.isNotEmpty((CharSequence)typeName)) continue;
            AtomicReference<Object> attributeDataType = new AtomicReference<Object>(null);
            if (!typeName.equals("array")) {
                if (typeName.equals("object")) {
                    attributeDataType.set(type);
                }
                this.buildUsedProperty(usedProperties, name, usedPropertySource, UsedPropertyType.fromString((String)typeName), false, attributeDataType.get(), usedSrcElement);
                continue;
            }
            MapUtils.deepMapTraversalSafe((Map<String, Object>)map1, arrayType -> {
                if (arrayType.equals("object")) {
                    attributeDataType.set(type);
                }
                this.buildUsedProperty(usedProperties, name, usedPropertySource, UsedPropertyType.fromString((String)((String)arrayType)), true, (Map)attributeDataType.get(), usedSrcElement);
            }, "type", "itemType", "name");
        }
    }

    private void findUsedPropertiesInHeaderModification(ChainElement element, Map<String, UsedProperty> usedProperties) {
        String elementType = element.getType();
        if ("header-modification".equals(elementType)) {
            Map elementProperties = element.getProperties();
            UsedPropertyElement usedElement = UsedPropertiesAnalyzer.buildUsedPropertyElement(element, UsedPropertyElementOperation.SET);
            Map headerModificationToAdd = elementProperties.getOrDefault("headerModificationToAdd", Collections.emptyMap());
            List headerModificationToRemove = elementProperties.getOrDefault("headerModificationToRemove", Collections.emptyList());
            if (headerModificationToAdd instanceof Map) {
                Map map = headerModificationToAdd;
                for (String key : map.keySet()) {
                    this.buildUsedProperty(usedProperties, key, UsedPropertySource.HEADER, UsedPropertyType.UNKNOWN_TYPE, usedElement);
                }
            }
            if (headerModificationToRemove instanceof Collection) {
                Collection collection = headerModificationToRemove;
                for (String key : collection) {
                    this.buildUsedProperty(usedProperties, key, UsedPropertySource.HEADER, UsedPropertyType.UNKNOWN_TYPE, usedElement);
                }
            }
        }
    }

    private void findUsedPropertiesInScript(ChainElement element, Map<String, UsedProperty> usedProperties) {
        String elementType = element.getType();
        if (ELEMENTS_WITH_SCRIPT.contains(elementType)) {
            Map elementProperties = element.getProperties();
            StringBuilder scripts = new StringBuilder();
            switch (elementType) {
                case "script": {
                    scripts.append((Object)elementProperties.getOrDefault("script", ""));
                    break;
                }
                case "service-call": {
                    Object before;
                    List after = elementProperties.getOrDefault("after", Collections.emptyList());
                    if (after instanceof Collection) {
                        Collection afterCollection = after;
                        for (Object afterObject : afterCollection) {
                            if (!(afterObject instanceof Map)) continue;
                            Map map = (Map)afterObject;
                            scripts.append((Object)map.getOrDefault("script", "")).append("\n");
                        }
                    }
                    if (!((before = elementProperties.get("before")) instanceof Map)) break;
                    Map beforeMap = (Map)before;
                    scripts.append((Object)beforeMap.getOrDefault("script", ""));
                    break;
                }
                case "http-trigger": {
                    Object handlerContainer = elementProperties.get("handlerContainer");
                    if (!(handlerContainer instanceof Map)) break;
                    Map containerMap = (Map)handlerContainer;
                    scripts.append((Object)containerMap.getOrDefault("script", ""));
                }
            }
            if (!scripts.isEmpty()) {
                UsedPropertyElement usedElement = UsedPropertyElement.builder().id(element.getId()).name(element.getName()).type(element.getType()).build();
                this.buildUsedProperties(scripts, UsedPropertyElementOperation.GET, usedElement, usedProperties, GROOVY_GET_HEADERS_PATTERN, UsedPropertySource.HEADER, GROOVY_GET_HEADER_GROUPS);
                this.buildUsedProperties(scripts, UsedPropertyElementOperation.SET, usedElement, usedProperties, GROOVY_SET_HEADERS_PATTERN, UsedPropertySource.HEADER, GROOVY_SET_HEADER_GROUPS);
                this.buildUsedProperties(scripts, UsedPropertyElementOperation.GET, usedElement, usedProperties, GROOVY_GET_PROPERTIES_PATTERN, UsedPropertySource.EXCHANGE_PROPERTY, GROOVY_GET_PROPERTIES_GROUPS);
                this.buildUsedProperties(scripts, UsedPropertyElementOperation.SET, usedElement, usedProperties, GROOVY_SET_PROPERTIES_PATTERN, UsedPropertySource.EXCHANGE_PROPERTY, GROOVY_SET_PROPERTIES_GROUPS);
            }
        }
    }

    private void buildUsedProperties(StringBuilder scripts, UsedPropertyElementOperation operation, UsedPropertyElement usedElement, Map<String, UsedProperty> usedProperties, Pattern pattern, UsedPropertySource usedPropertySource, int[] matchGroups) {
        Matcher groovyGetHeadersMatcher = pattern.matcher(scripts);
        block0: while (groovyGetHeadersMatcher.find()) {
            for (int group : matchGroups) {
                String propertyName = groovyGetHeadersMatcher.group(group);
                if (propertyName == null) continue;
                usedElement.getOperations().add(operation);
                this.buildUsedProperty(usedProperties, propertyName, usedPropertySource, UsedPropertyType.UNKNOWN_TYPE, usedElement);
                continue block0;
            }
        }
    }

    private void findUsedProperties(ChainElement element, Map<String, Object> properties, Map<String, UsedProperty> usedProperties) {
        String elementType = element.getType();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (EXCLUDE_MAPPER_ELEMENTS.contains(elementType) && MAPPING_DESCRIPTION.equals(key)) continue;
            this.parseProperty(element, usedProperties, value, elementType);
        }
    }

    private void findUsedProperties(ChainElement element, Collection<Object> properties, Map<String, UsedProperty> usedProperties) {
        String elementType = element.getType();
        for (Object property : properties) {
            this.parseProperty(element, usedProperties, property, elementType);
        }
    }

    private void parseProperty(ChainElement element, Map<String, UsedProperty> usedProperties, Object value, String elementType) {
        if (value instanceof Collection) {
            Collection listValue = (Collection)value;
            this.findUsedProperties(element, listValue, usedProperties);
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            this.findUsedProperties(element, mapValue, usedProperties);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            Matcher exPropertiesMatcher = PROPS_SIMPLE_PATTERN.matcher(stringValue);
            Matcher exHeadersMatcher = HEADERS_SIMPLE_PATTERN.matcher(stringValue);
            UsedPropertyElement usedElement = UsedPropertyElement.builder().id(element.getId()).name(element.getName()).type(elementType).build();
            usedElement.getOperations().add(UsedPropertyElementOperation.GET);
            this.findUsedPropertyMatches(usedProperties, exPropertiesMatcher, usedElement, UsedPropertySource.EXCHANGE_PROPERTY, EX_PROP_GROUPS);
            this.findUsedPropertyMatches(usedProperties, exHeadersMatcher, usedElement, UsedPropertySource.HEADER, EX_HEADER_GROUPS);
        }
    }

    private void findUsedPropertyMatches(Map<String, UsedProperty> usedProperties, Matcher exPropertiesMatcher, UsedPropertyElement usedElement, UsedPropertySource usedPropertySource, int[] groups) {
        block0: while (exPropertiesMatcher.find()) {
            for (int group : groups) {
                String propertyName = exPropertiesMatcher.group(group);
                if (propertyName == null) continue;
                this.buildUsedProperty(usedProperties, propertyName, usedPropertySource, UsedPropertyType.UNKNOWN_TYPE, usedElement);
                continue block0;
            }
        }
    }

    private void buildUsedProperty(Map<String, UsedProperty> usedProperties, String propName, UsedPropertySource source, UsedPropertyType type, UsedPropertyElement usedElement) {
        this.buildUsedProperty(usedProperties, propName, source, type, false, null, usedElement);
    }

    private void buildUsedProperty(Map<String, UsedProperty> usedProperties, String propName, UsedPropertySource source, UsedPropertyType type, boolean isArray, Map<String, Object> attributeDataType, UsedPropertyElement usedElement) {
        UsedProperty usedProperty = usedProperties.computeIfAbsent(UsedPropertiesAnalyzer.buildUsedPropertyKey(propName, source), key -> UsedProperty.builder().name(propName).source(source).type(type).isArray(isArray).attributeDataType(attributeDataType).build());
        Map relatedElements = usedProperty.getRelatedElements();
        UsedPropertyElement existingRelatedElement = (UsedPropertyElement)relatedElements.get(usedElement.getId());
        if (existingRelatedElement != null) {
            existingRelatedElement.merge(usedElement);
        } else {
            relatedElements.put(usedElement.getId(), usedElement);
        }
    }

    private static String buildUsedPropertyKey(String name, UsedPropertySource source) {
        return name + source.toString();
    }
}

