/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.codeview.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class CodeviewChainElementDeserializer
extends StdDeserializer<ChainElement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeviewChainElementDeserializer.class);
    private final ObjectMapper objectMapper;

    public CodeviewChainElementDeserializer(@Qualifier(value="primaryObjectMapper") ObjectMapper objectMapper) {
        super(ChainElement.class);
        this.objectMapper = objectMapper;
    }

    public ChainElement deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ChainElement resultElement = new ChainElement();
        YAMLMapper mapper = (YAMLMapper)parser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(parser);
        JsonNode idNode = node.get("id");
        JsonNode nameNode = node.get("name");
        JsonNode descriptionNode = node.get("description");
        ObjectNode propertiesNode = (ObjectNode)node.get("properties");
        resultElement.setId(idNode != null && !(idNode instanceof NullNode) ? idNode.asText() : null);
        resultElement.setName(nameNode != null && !(nameNode instanceof NullNode) ? nameNode.asText() : null);
        resultElement.setDescription(descriptionNode != null && !(descriptionNode instanceof NullNode) ? descriptionNode.asText() : null);
        this.restoreProperties(propertiesNode, resultElement);
        return resultElement;
    }

    private void restoreProperties(ObjectNode propertiesNode, ChainElement resultElement) {
        Map elementProperties = new HashMap();
        if (propertiesNode != null) {
            elementProperties = (Map)this.objectMapper.convertValue((Object)propertiesNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        resultElement.getProperties().putAll(elementProperties);
    }
}

