/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.codeview.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.TreeMap;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeviewChainElementSerializer
extends StdSerializer<ChainElement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeviewChainElementSerializer.class);

    public CodeviewChainElementSerializer() {
        super(ChainElement.class);
    }

    public void serialize(ChainElement element, JsonGenerator generator, SerializerProvider serializer) throws IOException {
        try {
            generator.writeStartObject();
            generator.writeStringField("id", element.getId());
            if (element.getName() != null) {
                generator.writeStringField("name", element.getName());
            }
            generator.writeStringField("description", element.getDescription());
            this.writeProperties(element, generator);
            generator.writeEndObject();
        }
        catch (IOException e) {
            log.warn("Exception while serializing ChainElement {}, exception: ", (Object)element.getId(), (Object)e);
            throw e;
        }
    }

    private void writeProperties(ChainElement element, JsonGenerator generator) throws IOException {
        TreeMap properties = new TreeMap(element.getProperties());
        generator.writeObjectField("properties", properties);
    }
}

