/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateSchema;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.exception.ElementDDSConverterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class JsonSchemaParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaParser.class);
    public static final String UNKNOWN_TYPE = "unknown type";
    private final ObjectMapper jsonMapper;

    @Autowired
    public JsonSchemaParser(@Qualifier(value="primaryObjectMapper") ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public TemplateSchema toProperties(String jsonSchema) {
        if (StringUtils.isNotEmpty((CharSequence)jsonSchema)) {
            try {
                JsonNode root = this.jsonMapper.readTree(jsonSchema);
                return this.toProperties(root);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to parse JSON Schema: {}...", (Object)jsonSchema.substring(0, 200), (Object)e);
                throw new ElementDDSConverterException("Failed to parse JSON Schema for element: " + jsonSchema.substring(0, 200) + "...", e);
            }
        }
        return TemplateSchema.EMPTY;
    }

    public TemplateSchema toProperties(JsonNode schemaRoot) {
        return this.toProperties(schemaRoot, new ArrayList<Map<String, String>>(), new HashMap<String, List<Map<String, String>>>());
    }

    private TemplateSchema toProperties(JsonNode schemaRoot, List<Map<String, String>> resultProperties, Map<String, List<Map<String, String>>> resultDefinitions) {
        if (!this.isEmptyNode(schemaRoot)) {
            JsonNode schemeProperties = schemaRoot.path("properties");
            JsonNode arrayItems = schemaRoot.path("items");
            this.parseProperties(schemaRoot, resultProperties, schemeProperties, arrayItems);
            this.parseDefinitions(resultDefinitions, schemaRoot.path("$defs"));
            this.parseDefinitions(resultDefinitions, schemaRoot.path("definitions"));
        }
        return new TemplateSchema(resultProperties, resultDefinitions);
    }

    private void parseDefinitions(Map<String, List<Map<String, String>>> resultDefinitions, JsonNode definitions) {
        if (!this.isEmptyNode(definitions)) {
            Iterator it = definitions.fieldNames();
            while (it.hasNext()) {
                String definitionName = (String)it.next();
                ArrayList<Map<String, String>> definitionProperties = new ArrayList<Map<String, String>>();
                resultDefinitions.put(definitionName, definitionProperties);
                this.toProperties(definitions.get(definitionName), definitionProperties, resultDefinitions);
            }
        }
    }

    private void parseProperties(JsonNode schemaRoot, List<Map<String, String>> resultProperties, JsonNode schemeProperties, JsonNode arrayItems) {
        if (this.isEmptyNode(schemeProperties)) {
            Set<String> requiredSet = this.parseRequiredToSet(schemaRoot.path("required"));
            this.parseSchemeProperty(this.isEmptyNode(arrayItems) ? "\u2014" : "[]", schemaRoot, "", requiredSet, resultProperties);
        } else {
            this.fillPropertiesMap(schemeProperties, schemaRoot.path("required"), "", resultProperties);
        }
    }

    private void fillPropertiesMap(JsonNode properties, JsonNode requiredList, String path, List<Map<String, String>> result) {
        Set<String> requiredSet = this.parseRequiredToSet(requiredList);
        Iterator it = properties.fieldNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            JsonNode property = properties.get(name);
            this.parseSchemeProperty(name, property, path, requiredSet, result);
        }
    }

    @NotNull
    private Set<String> parseRequiredToSet(JsonNode requiredList) {
        HashSet<String> requiredSet = new HashSet<String>();
        if (requiredList != null && !(requiredList instanceof NullNode) && !(requiredList instanceof MissingNode)) {
            for (JsonNode required : requiredList) {
                requiredSet.add(required.asText());
            }
        }
        return requiredSet;
    }

    private void parseSchemeProperty(String name, JsonNode property, String path, Set<String> requiredFields, List<Map<String, String>> result) {
        String baseType = this.detectPropertyBaseType(property);
        String composition = this.detectComposition(property);
        boolean hasComposition = StringUtils.isNotEmpty((CharSequence)composition);
        String compositionType = JsonSchemaParser.buildCompositionType(hasComposition, baseType, composition);
        if (baseType.equals("array")) {
            JsonNode items = property.path("items");
            if (!this.isEmptyNode(items) && !hasComposition) {
                String arrayType = this.detectPropertyBaseType(items);
                this.writeResult(name, property, path, requiredFields, result, "array of " + arrayType);
                if (arrayType.equals("array") || arrayType.equals("object")) {
                    this.fillPropertiesMap(items.path("properties"), items.path("required"), path + name + ".", result);
                }
            } else {
                this.writeResult(name, property, path, requiredFields, result, compositionType);
            }
        } else if (baseType.equals("object")) {
            this.writeResult(name, property, path, requiredFields, result, compositionType);
            if (!hasComposition) {
                this.fillPropertiesMap(property.path("properties"), property.path("required"), path + name + ".", result);
            }
        } else {
            this.writeResult(name, property, path, requiredFields, result, hasComposition ? compositionType : baseType);
        }
    }

    private static String buildCompositionType(boolean hasComposition, @Nullable String type, String composition) {
        return hasComposition ? (String)(type == null || UNKNOWN_TYPE.equals(type) ? "" : type + " ") + composition + "[...]" : type;
    }

    private String detectComposition(JsonNode property) {
        JsonNode allOf = property.path("allOf");
        if (!this.isEmptyNode(allOf)) {
            return "allOf";
        }
        JsonNode oneOf = property.path("oneOf");
        if (!this.isEmptyNode(oneOf)) {
            return "oneOf";
        }
        JsonNode anyOf = property.path("anyOf");
        if (!this.isEmptyNode(anyOf)) {
            return "anyOf";
        }
        JsonNode not = property.path("not");
        if (!this.isEmptyNode(not)) {
            return "not";
        }
        return null;
    }

    @NotNull
    private String detectPropertyBaseType(JsonNode property) {
        String type = property.path("type").asText().toLowerCase();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            return type;
        }
        JsonNode jsonNode = property.path("type");
        if (jsonNode instanceof ArrayNode) {
            ArrayNode typeList = (ArrayNode)jsonNode;
            try {
                return this.jsonMapper.writeValueAsString((Object)typeList).replace("\"", "");
            }
            catch (JsonProcessingException e) {
                return UNKNOWN_TYPE;
            }
        }
        String ref = property.path("$ref").asText();
        if (!StringUtils.isEmpty((CharSequence)ref)) {
            return "reference to " + ref;
        }
        JsonNode enumNode = property.path("enum");
        if (!this.isEmptyNode(enumNode)) {
            return "enum";
        }
        JsonNode constNode = property.path("const");
        if (!this.isEmptyNode(constNode)) {
            return "const";
        }
        return UNKNOWN_TYPE;
    }

    private void writeResult(String name, JsonNode property, String path, Set<String> requiredFields, List<Map<String, String>> result, String type) {
        String description = property.path("description").asText();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", path + name);
        props.put("optionality", requiredFields.contains(name) ? "mandatory" : "optional");
        props.put("type", type);
        props.put("description", StringUtils.isEmpty((CharSequence)description) ? null : description);
        result.add(props);
    }

    private boolean isEmptyNode(JsonNode schemeProperties) {
        return schemeProperties == null || schemeProperties instanceof NullNode || schemeProperties instanceof MissingNode;
    }
}

