/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.Operation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.SystemModel;
import org.qubership.integration.platform.designtime.catalog.model.dds.TemplateChainElement;
import org.qubership.integration.platform.designtime.catalog.service.OperationService;
import org.qubership.integration.platform.designtime.catalog.service.SystemModelService;
import org.qubership.integration.platform.designtime.catalog.service.SystemService;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.ElementTemplateUtils;
import org.qubership.integration.platform.designtime.catalog.service.ddsgenerator.elements.converter.ElementDDSConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceCallDDSConverter
extends ElementDDSConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceCallDDSConverter.class);
    private static final Map<String, String> TYPE_MAPPING = Map.of("service-call", "Service Call");
    private static final Map<String, String> HANDLING_TYPE_MAPPING = Map.of("mapper-2", "mapper");
    private final ElementTemplateUtils elementTemplateUtils;
    private final SystemService systemService;
    private final SystemModelService systemModelService;
    private final OperationService operationService;

    @Autowired
    public ServiceCallDDSConverter(ElementTemplateUtils elementTemplateUtils, SystemService systemService, SystemModelService systemModelService, OperationService operationService) {
        this.elementTemplateUtils = elementTemplateUtils;
        this.systemService = systemService;
        this.systemModelService = systemModelService;
        this.operationService = operationService;
    }

    @Override
    protected Map<String, String> getTypeMapping() {
        return TYPE_MAPPING;
    }

    @Override
    public TemplateChainElement convert(ChainElement element) {
        String string;
        Map elementProps = element.getProperties();
        HashMap<String, Object> elementTemplateProps = new HashMap<String, Object>();
        TemplateChainElement.TemplateChainElementBuilder builder = this.getBuilder(element);
        builder.properties(elementTemplateProps);
        ArrayList errorHandlingValues = new ArrayList();
        Object v = elementProps.get("after");
        if (v instanceof Collection) {
            Collection after = (Collection)v;
            for (Object item : after) {
                Map itemMap = (Map)item;
                if (!itemMap.containsKey("code")) continue;
                String type = itemMap.getOrDefault("type", null);
                if (StringUtils.isNotEmpty((CharSequence)type) && HANDLING_TYPE_MAPPING.containsKey(type)) {
                    type = HANDLING_TYPE_MAPPING.get(type);
                }
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("type", StringUtils.capitalize((String)type));
                hm.put("responseCode", (String)itemMap.get("label"));
                errorHandlingValues.add(hm);
            }
        }
        elementTemplateProps.put("errorHandling", errorHandlingValues);
        Object authorizationConfiguration = elementProps.get("authorizationConfiguration");
        HashMap<String, String> authProps = new HashMap<String, String>();
        if (authorizationConfiguration instanceof Map) {
            Map authConfig = (Map)authorizationConfiguration;
            string = StringUtils.capitalize((String)((String)authConfig.get("type")));
        } else {
            string = null;
        }
        authProps.put("type", string);
        elementTemplateProps.put("authorization", authProps);
        try {
            String integrationSystemId = (String)elementProps.get("integrationSystemId");
            String integrationSpecificationId = (String)elementProps.get("integrationSpecificationId");
            String integrationOperationId = (String)elementProps.get("integrationOperationId");
            if (integrationSystemId != null && integrationSpecificationId != null && integrationOperationId != null) {
                IntegrationSystem system = this.systemService.findById(integrationSystemId);
                SystemModel spec = this.systemModelService.getSystemModel(integrationSpecificationId);
                Operation operation = this.operationService.getOperation(integrationOperationId);
                elementTemplateProps.put("serviceName", system.getName());
                elementTemplateProps.put("specificationName", spec.getName());
                elementTemplateProps.put("operationName", operation.getName());
                elementTemplateProps.put("operationType", operation.getMethod());
            }
            this.elementTemplateUtils.addJSONSchemas(elementProps, elementTemplateProps);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }
}

