/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.model.system.ServiceEnvironment;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemRepository;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.designtime.catalog.service.EnvironmentService;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.qubership.integration.platform.designtime.catalog.utils.DiagramBuilderUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncApiTriggerDesignProcessor
implements DesignProcessor {
    private final SystemRepository systemRepository;
    private final EnvironmentService environmentService;

    @Autowired
    public AsyncApiTriggerDesignProcessor(SystemRepository systemRepository, EnvironmentService environmentService) {
        this.systemRepository = systemRepository;
        this.environmentService = environmentService;
    }

    @Override
    public Set<String> supportedElementTypes() {
        return Set.of("async-api-trigger");
    }

    @Override
    public String getExternalParticipantId(ChainElement element) {
        IntegrationSystem system = this.getSystem(element);
        return system == null ? null : DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)system.getId());
    }

    @Override
    public String getExternalParticipantName(ChainElement element) {
        IntegrationSystem system = this.getSystem(element);
        return system == null ? null : "Service: " + system.getName();
    }

    private IntegrationSystem getSystem(ChainElement element) {
        Map properties = element.getProperties();
        return properties.containsKey("integrationSystemId") ? (IntegrationSystem)this.systemRepository.findById((Object)((String)properties.get("integrationSystemId"))).orElseThrow(() -> new RuntimeException("Can't find system with id: " + String.valueOf(properties.get("integrationSystemId")))) : null;
    }

    @Override
    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        Map properties = element.getProperties();
        String externalParticipantId = this.getExternalParticipantId(element);
        String path = this.buildPathMessage(properties);
        if (externalParticipantId != null) {
            builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, externalParticipantId, refChainId, "Pull message " + path);
            DiagramBuilderUtil.buildValidateRequest(refChainId, builder, properties);
        }
    }

    @Override
    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }

    private String buildPathMessage(Map<String, Object> elementProperties) {
        String operationProtocol = (String)elementProperties.get("integrationOperationProtocolType");
        String systemId = (String)elementProperties.get("integrationSystemId");
        if (systemId != null) {
            List<ServiceEnvironment> environments = this.environmentService.generateSystemEnvironments(Set.of(systemId));
            if (!environments.isEmpty() && operationProtocol != null) {
                ServiceEnvironment env = environments.get(0);
                Map asyncProperties = ElementUtils.mergeProperties(elementProperties.getOrDefault("integrationOperationAsyncProperties", Collections.emptyMap()), (Map)env.getProperties());
                switch (operationProtocol) {
                    case "amqp": {
                        return "from queue " + String.valueOf(asyncProperties.getOrDefault("queues", "%empty_property%"));
                    }
                    case "kafka": {
                        switch (env.getSourceType()) {
                            case MANUAL: {
                                return "from topic " + String.valueOf(elementProperties.getOrDefault("integrationOperationPath", "%empty_property%"));
                            }
                            case MAAS_BY_CLASSIFIER: {
                                return "from topic by classifier " + String.valueOf(asyncProperties.getOrDefault("maas.classifier.name", "%empty_property%"));
                            }
                        }
                    }
                }
            }
        } else {
            return "%empty_property%";
        }
        return (String)elementProperties.get("integrationOperationPath");
    }
}

