/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Set;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramConstants;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.springframework.stereotype.Component;

@Component
public class CheckpointDesignProcessor
implements DesignProcessor {
    @Override
    public Set<String> supportedElementTypes() {
        return Set.of("checkpoint");
    }

    @Override
    public String getExternalParticipantId(ChainElement element) {
        return DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)this.getExternalParticipantName(element));
    }

    @Override
    public String getExternalParticipantName(ChainElement element) {
        return "Unknown user";
    }

    @Override
    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        String checkpointTitle = element.getName() + " with id " + element.getPropertyAsString("checkpointElementId");
        builder.append(DiagramOperationType.START_GROUP, checkpointTitle);
        builder.append(DiagramOperationType.START_COLORED_GROUP, DiagramConstants.GROUP_BG_RGB[0], DiagramConstants.GROUP_BG_RGB[1], DiagramConstants.GROUP_BG_RGB[2], refChainId, checkpointTitle);
        builder.append(DiagramOperationType.START_ALT, "Trigger");
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, this.getExternalParticipantId(element), refChainId, "Request to retry session");
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, refChainId, refChainId, "Load context");
        builder.append(DiagramOperationType.ELSE, "Checkpoint");
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, refChainId, refChainId, "Save context");
        builder.append(DiagramOperationType.END, new String[0]);
        builder.append(DiagramOperationType.END, new String[0]);
    }

    @Override
    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }
}

