/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Set;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.catalog.util.SimpleHttpUriUtils;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.springframework.stereotype.Component;

@Component
public class HttpSenderDesignProcessor
implements DesignProcessor {
    @Override
    public Set<String> supportedElementTypes() {
        return Set.of("http-sender");
    }

    @Override
    public String getExternalParticipantId(ChainElement element) {
        return DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)this.getExternalParticipantName(element));
    }

    @Override
    public String getExternalParticipantName(ChainElement element) {
        String host = element.getPropertyAsString("uri");
        try {
            host = SimpleHttpUriUtils.extractProtocolAndDomainWithPort((String)host);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String message = element.getProperty("isExternalCall") == null || (Boolean)element.getProperty("isExternalCall") != false ? "External" : "Internal";
        return message + " service: " + (host == null ? "%empty_property%" : host);
    }

    @Override
    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        String methods = element.getPropertyAsString("httpMethod");
        String path = SimpleHttpUriUtils.extractPathAndQueryFromUri((String)element.getPropertyAsString("uri"));
        String title = (methods == null ? "%empty_property%" : methods) + ", " + (path == null ? "%empty_property%" : path);
        String externalParticipantId = this.getExternalParticipantId(element);
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, refChainId, externalParticipantId, title);
        builder.append(DiagramOperationType.ACTIVATE, externalParticipantId);
        builder.append(DiagramOperationType.LINE_WITH_ARROW_DOTTED_RIGHT, externalParticipantId, refChainId, "Response");
        builder.append(DiagramOperationType.DEACTIVATE, externalParticipantId);
    }

    @Override
    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
    }
}

