/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.system.IntegrationSystem;
import org.qubership.integration.platform.catalog.persistence.configs.repository.system.SystemRepository;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.DesignProcessor;
import org.qubership.integration.platform.designtime.catalog.utils.DiagramBuilderUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpTriggerDesignProcessor
implements DesignProcessor {
    private final SystemRepository systemRepository;

    @Autowired
    public HttpTriggerDesignProcessor(SystemRepository systemRepository) {
        this.systemRepository = systemRepository;
    }

    @Override
    public Set<String> supportedElementTypes() {
        return Set.of("http-trigger");
    }

    @Override
    public String getExternalParticipantId(ChainElement element) {
        IntegrationSystem system = this.getSystem(element);
        String serviceId = this.isManualSource(element) ? this.getExternalParticipantName(element) : (system == null ? null : system.getId());
        return serviceId == null ? null : DiagramBuilderEscapeUtil.removeOrReplaceUnsupportedCharacters((String)serviceId);
    }

    @Override
    public String getExternalParticipantName(ChainElement element) {
        Map properties = element.getProperties();
        IntegrationSystem system = this.getSystem(element);
        boolean isExternal = properties.getOrDefault("externalRoute", true);
        boolean isPrivate = properties.getOrDefault("privateRoute", false);
        String message = "Unknown " + (String)(isExternal || isPrivate ? "external (via " + this.getRouteMessage(isExternal, isPrivate) + " route)" : "internal") + " service";
        message = this.isManualSource(element) ? message : (system == null ? null : "Service: " + system.getName());
        return message;
    }

    private String getRouteMessage(boolean isExternal, boolean isPrivate) {
        if (isExternal && isPrivate) {
            return "external or private";
        }
        if (isExternal) {
            return "external";
        }
        return "private";
    }

    private IntegrationSystem getSystem(ChainElement element) {
        Map properties = element.getProperties();
        return properties.containsKey("integrationSystemId") ? (IntegrationSystem)this.systemRepository.findById((Object)((String)properties.get("integrationSystemId"))).orElseThrow(() -> new RuntimeException("Can't find system with id: " + String.valueOf(properties.get("integrationSystemId")))) : null;
    }

    @Override
    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        Map properties = element.getProperties();
        String methods = element.getPropertyAsString("httpMethodRestrict");
        String uri = (String)(this.isManualSource(element) ? properties.get("contextPath") : properties.get("integrationOperationPath"));
        String title = "HTTP request to " + (uri == null ? "%empty_property%" : uri) + ", allowed methods=[" + (StringUtils.isBlank((CharSequence)methods) ? "ALL" : methods) + "]";
        builder.append(DiagramOperationType.LINE_WITH_ARROW_SOLID_RIGHT, this.getExternalParticipantId(element), refChainId, title);
        if (!this.isManualSource(element)) {
            DiagramBuilderUtil.buildValidateRequest(refChainId, builder, properties);
        }
    }

    @Override
    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        builder.append(DiagramOperationType.LINE_WITH_ARROW_DOTTED_RIGHT, refChainId, this.getExternalParticipantId(element), "Response");
    }

    private boolean isManualSource(ChainElement element) {
        String systemType = (String)element.getProperties().get("systemType");
        return StringUtils.isEmpty((CharSequence)systemType);
    }
}

