/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors;

import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import org.qubership.integration.platform.catalog.model.designgenerator.DiagramOperationType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.util.DiagramBuilderEscapeUtil;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.SequenceDiagramBuilder;
import org.qubership.integration.platform.designtime.catalog.service.designgenerator.processors.interfaces.ContainerDesignProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.comparator.Comparators;

@Component
public class LoopContainerDesignProcessor
implements ContainerDesignProcessor {
    @Override
    public Comparator<ChainElement> getComparator() {
        return Comparators.comparable();
    }

    @Override
    public Predicate<ChainElement> getChildrenFilter() {
        return element -> element.getInputDependencies().isEmpty();
    }

    @Override
    public boolean isContainerWithRestrictions() {
        return false;
    }

    @Override
    public Set<String> supportedElementTypes() {
        return Set.of("loop-2");
    }

    @Override
    public String getExternalParticipantId(ChainElement element) {
        return null;
    }

    @Override
    public String getExternalParticipantName(ChainElement element) {
        return null;
    }

    @Override
    public void processBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        ContainerChainElement containerElement;
        if (element instanceof ContainerChainElement && !(containerElement = (ContainerChainElement)element).getElements().isEmpty()) {
            builder.append(DiagramOperationType.START_LOOP, DiagramBuilderEscapeUtil.substituteProperties((String)refChainId, (ChainElement)element, (String)"##{expression}"));
        }
    }

    @Override
    public void processAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element) {
        ContainerChainElement containerElement;
        if (element instanceof ContainerChainElement && !(containerElement = (ContainerChainElement)element).getElements().isEmpty()) {
            builder.append(DiagramOperationType.END, new String[0]);
        }
    }

    @Override
    public void processChildAfter(String refChainId, SequenceDiagramBuilder builder, ChainElement element, ChainElement child) {
    }

    @Override
    public void processChildBefore(String refChainId, SequenceDiagramBuilder builder, ChainElement element, ChainElement child) {
    }
}

