/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.exportimport.instructions;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.qubership.integration.platform.catalog.exception.ImportInstructionsExternalException;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportEntityType;
import org.qubership.integration.platform.catalog.model.exportimport.instructions.ImportInstructionAction;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.ActionLog;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.EntityType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.actionlog.LogOperation;
import org.qubership.integration.platform.catalog.persistence.configs.entity.instructions.ImportInstruction;
import org.qubership.integration.platform.catalog.persistence.configs.repository.instructions.ImportInstructionsRepository;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.designtime.catalog.exception.exceptions.ImportInstructionsValidationException;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.exportimport.instructions.DeleteInstructionsRequest;
import org.qubership.integration.platform.designtime.catalog.service.filter.ImportInstructionFilterSpecificationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportInstructionsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsService.class);
    public static final String UNIQUE_OVERRIDE_DB_CONSTRAINT_NAME = "import_instructions_unique_override_idx";
    public static final String OVERRIDE_ACTION_DB_CONSTRAINT_NAME = "overridden_by_id_only_for_override";
    private final ImportInstructionsRepository importInstructionsRepository;
    private final ImportInstructionFilterSpecificationBuilder importInstructionFilterSpecificationBuilder;
    private final ActionsLogService actionsLogService;

    public ImportInstructionsService(ImportInstructionsRepository importInstructionsRepository, ImportInstructionFilterSpecificationBuilder importInstructionFilterSpecificationBuilder, ActionsLogService actionsLogService) {
        this.importInstructionsRepository = importInstructionsRepository;
        this.importInstructionFilterSpecificationBuilder = importInstructionFilterSpecificationBuilder;
        this.actionsLogService = actionsLogService;
    }

    public List<ImportInstruction> getImportInstructions() {
        return this.importInstructionsRepository.findAll();
    }

    public List<ImportInstruction> getImportInstructions(Collection<FilterRequestDTO> filterRequestDTOS) {
        Specification<ImportInstruction> specification = this.importInstructionFilterSpecificationBuilder.buildFilter(filterRequestDTOS);
        return this.importInstructionsRepository.findAll(specification);
    }

    public List<ImportInstruction> searchImportInstructions(String searchCondition) {
        List<FilterRequestDTO> filters = Stream.of(FilterFeature.ID, FilterFeature.OVERRIDDEN_BY).map(feature -> FilterRequestDTO.builder().feature((FilterFeature)((Object)feature)).condition(FilterCondition.CONTAINS).value(searchCondition).build()).collect(Collectors.toList());
        return this.importInstructionsRepository.findAll(this.importInstructionFilterSpecificationBuilder.buildSearch(filters));
    }

    @Transactional
    public ImportInstruction addImportInstruction(ImportInstruction importInstruction) {
        this.validateImportInstruction(importInstruction);
        if (this.importInstructionsRepository.existsById((Object)importInstruction.getId())) {
            log.error("Instruction for {} already exist", (Object)importInstruction.getId());
            throw new ImportInstructionsExternalException("Instruction for " + importInstruction.getId() + " already exist");
        }
        importInstruction = this.importInstructionsRepository.persistAndReturn(importInstruction);
        this.logAction(importInstruction.getId(), importInstruction.getEntityType(), LogOperation.CREATE);
        return importInstruction;
    }

    @Transactional
    public ImportInstruction updateImportInstruction(ImportInstruction importInstruction) {
        this.validateImportInstruction(importInstruction);
        ImportInstruction existingImportInstruction = (ImportInstruction)this.importInstructionsRepository.findById((Object)importInstruction.getId()).orElseThrow(() -> {
            log.error("Instruction with id {} does not exist", (Object)importInstruction.getId());
            return new ImportInstructionsExternalException("Instruction with id " + importInstruction.getId() + " does not exist");
        });
        if (importInstruction.getEntityType() != existingImportInstruction.getEntityType()) {
            log.error("Import instruction entity type cannot be updated");
            throw new ImportInstructionsValidationException("Import instruction entity type cannot be updated");
        }
        ImportInstruction resultImportInstruction = this.importInstructionsRepository.mergeAndReturn(existingImportInstruction.patch(importInstruction));
        this.logAction(resultImportInstruction.getId(), resultImportInstruction.getEntityType(), LogOperation.UPDATE);
        return resultImportInstruction;
    }

    @Transactional
    public void deleteImportInstructionsById(DeleteInstructionsRequest deleteInstructionsRequest) {
        Set instructionsToDelete = Stream.of(deleteInstructionsRequest.getChains().stream(), deleteInstructionsRequest.getServices().stream()).flatMap(Function.identity()).collect(Collectors.toSet());
        List importInstructions = this.importInstructionsRepository.findAllById(instructionsToDelete);
        this.importInstructionsRepository.deleteAll((Iterable)importInstructions);
        importInstructions.forEach(importInstruction -> this.logAction(importInstruction.getId(), importInstruction.getEntityType(), LogOperation.DELETE));
    }

    private void validateImportInstruction(ImportInstruction importInstruction) {
        ImportEntityType entityType = importInstruction.getEntityType();
        ImportInstructionAction action = importInstruction.getAction();
        boolean failed = false;
        String errorMessage = null;
        switch (entityType) {
            case CHAIN: {
                failed = action == ImportInstructionAction.OVERRIDE && importInstruction.getOverriddenBy() == null;
                errorMessage = "Overridden By must not be null for instruction with the OVERRIDE action";
                break;
            }
            case SERVICE: {
                failed = action == ImportInstructionAction.OVERRIDE;
                errorMessage = "Service instruction does not support the OVERRIDE action";
                break;
            }
            case SPECIFICATION_GROUP: {
                failed = action == ImportInstructionAction.IGNORE || action == ImportInstructionAction.OVERRIDE;
                errorMessage = "Specification Group instruction does not support action IGNORE and OVERRIDE";
                break;
            }
            case SPECIFICATION: {
                failed = action == ImportInstructionAction.IGNORE || action == ImportInstructionAction.OVERRIDE;
                errorMessage = "Specification instruction does not support action IGNORE and OVERRIDE";
            }
        }
        if (failed) {
            log.error(errorMessage);
            throw new ImportInstructionsValidationException(errorMessage);
        }
    }

    private void logAction(String entityName, ImportEntityType importEntityType, LogOperation logOperation) {
        this.actionsLogService.logAction(ActionLog.builder().entityName(entityName).parentName(importEntityType != null ? importEntityType.name() : null).entityType(EntityType.IMPORT_INSTRUCTION).operation(logOperation).build());
    }
}

