/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.service.filter.FilterConditionPredicateBuilderFactory;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ChainFilterSpecificationBuilder {
    private static final Set<FilterFeature> ELEMENT_PARAMS_FEATURE_SET = Set.of(FilterFeature.EXCHANGE, FilterFeature.QUEUE, FilterFeature.TOPIC, FilterFeature.SERVICE_ID, FilterFeature.CLASSIFIER);
    private final FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory;

    @Autowired
    public ChainFilterSpecificationBuilder(FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory) {
        this.filterConditionPredicateBuilderFactory = filterConditionPredicateBuilderFactory;
    }

    public Specification<Chain> buildSearch(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::or, true);
    }

    public Specification<Chain> buildFilter(Collection<FilterRequestDTO> filters) {
        return this.build(filters, CriteriaBuilder::and, false);
    }

    public Specification<Chain> build(Collection<FilterRequestDTO> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator, boolean searchMode) {
        Map<FilterFeature, List<FilterRequestDTO>> filtersMap = filters.stream().collect(Collectors.groupingBy(FilterRequestDTO::getFeature));
        ArrayList<FilterRequestDTO> commonFilters = new ArrayList<FilterRequestDTO>();
        HashMap<FilterFeature, List<FilterRequestDTO>> orFilters = new HashMap<FilterFeature, List<FilterRequestDTO>>();
        for (Map.Entry<FilterFeature, List<FilterRequestDTO>> entry : filtersMap.entrySet()) {
            List<FilterRequestDTO> filterRequestDTOs = entry.getValue();
            commonFilters.addAll(filterRequestDTOs.stream().filter(dto -> dto.getCondition() == FilterCondition.IS_NOT || !ELEMENT_PARAMS_FEATURE_SET.contains((Object)dto.getFeature())).toList());
            orFilters.put(entry.getKey(), filterRequestDTOs.stream().filter(dto -> dto.getCondition() != FilterCondition.IS_NOT && ELEMENT_PARAMS_FEATURE_SET.contains((Object)dto.getFeature())).toList());
        }
        return this.buildComplexSpec(commonFilters, orFilters, predicateAccumulator, searchMode);
    }

    private Specification<Chain> buildComplexSpec(List<FilterRequestDTO> commonFilters, Map<FilterFeature, List<FilterRequestDTO>> orFilters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator, boolean searchMode) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            ArrayList<Predicate> havingPredicates = new ArrayList<Predicate>();
            Predicate commonResult = null;
            if (!commonFilters.isEmpty()) {
                Predicate[] predicates = (Predicate[])commonFilters.stream().map(filter -> this.buildPredicate((Root<Chain>)root, criteriaBuilder, (FilterRequestDTO)filter)).toArray(Predicate[]::new);
                commonResult = commonFilters.size() > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
            }
            Predicate orResult = null;
            if (!orFilters.isEmpty()) {
                if (!searchMode) {
                    Path chainIdPath = root.get("id");
                    query.groupBy(new Expression[]{chainIdPath});
                }
                ArrayList orPredicates = new ArrayList();
                for (Map.Entry entry : orFilters.entrySet()) {
                    Expression expression;
                    FilterFeature feature = (FilterFeature)((Object)((Object)entry.getKey()));
                    List filterRequestDTOS = (List)entry.getValue();
                    filterRequestDTOS.stream().map(dto -> this.buildPredicate((Root<Chain>)root, criteriaBuilder, (FilterRequestDTO)dto)).forEach(orPredicates::add);
                    if (filterRequestDTOS.isEmpty()) continue;
                    if ((expression = (switch (feature) {
                        case FilterFeature.TOPIC -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "integrationOperationPath")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "topics")));
                        case FilterFeature.QUEUE -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "queues")), criteriaBuilder.countDistinct(this.getChainElementSubPropertyExpression((Root<Chain>)root, criteriaBuilder, "integrationOperationAsyncProperties", "queues")));
                        case FilterFeature.EXCHANGE -> criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "integrationOperationPath")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "exchange")));
                        case FilterFeature.SERVICE_ID -> criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "integrationSystemId"));
                        case FilterFeature.CLASSIFIER -> criteriaBuilder.sum(criteriaBuilder.sum(criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "topicsClassifierName")), criteriaBuilder.countDistinct(this.getChainElementPropertyExpression((Root<Chain>)root, criteriaBuilder, "vhostClassifierName"))), criteriaBuilder.countDistinct(this.getChainElementSubPropertyExpression((Root<Chain>)root, criteriaBuilder, "integrationOperationAsyncProperties", "maas.classifier.name")));
                        default -> null;
                    })) == null) continue;
                    havingPredicates.add(criteriaBuilder.greaterThanOrEqualTo(expression, (Comparable)Long.valueOf(filterRequestDTOS.size())));
                }
                if (!havingPredicates.isEmpty() && !orPredicates.isEmpty()) {
                    if (!searchMode) {
                        query.having((Expression)(havingPredicates.size() > 1 ? criteriaBuilder.and((Predicate[])havingPredicates.toArray(Predicate[]::new)) : (Expression)havingPredicates.get(0)));
                    }
                    Predicate predicate = orResult = orPredicates.size() > 1 ? criteriaBuilder.or((Predicate[])orPredicates.toArray(Predicate[]::new)) : (Predicate)orPredicates.get(0);
                }
            }
            if (commonResult == null && orResult != null) {
                return orResult;
            }
            if (commonResult != null && orResult == null) {
                return commonResult;
            }
            if (commonResult != null && orResult != null) {
                return (Predicate)predicateAccumulator.apply(criteriaBuilder, new Predicate[]{commonResult, orResult});
            }
            return null;
        };
    }

    private Predicate buildPredicate(Root<Chain> root, CriteriaBuilder criteriaBuilder, FilterRequestDTO filter) {
        boolean isNegativeElementFilter = (filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.NOT_IN) && ELEMENT_PARAMS_FEATURE_SET.contains((Object)filter.getFeature());
        BiFunction conditionPredicateBuilder = this.filterConditionPredicateBuilderFactory.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String value = filter.getValue();
        return switch (filter.getFeature()) {
            case FilterFeature.ID -> (Predicate)conditionPredicateBuilder.apply(root.get("id"), value);
            case FilterFeature.NAME -> (Predicate)conditionPredicateBuilder.apply(root.get("name"), value);
            case FilterFeature.DESCRIPTION -> (Predicate)conditionPredicateBuilder.apply(root.get("description"), value);
            case FilterFeature.ENGINES -> (Predicate)conditionPredicateBuilder.apply(this.getDeploymentPropertyExpression(root, "domain"), value);
            case FilterFeature.LOGGING, FilterFeature.STATUS, FilterFeature.ELEMENT -> criteriaBuilder.conjunction();
            case FilterFeature.PATH -> criteriaBuilder.or(new Predicate[]{criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-trigger"), (Expression)criteriaBuilder.or((Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath"), value), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "contextPath"), value))), criteriaBuilder.and(new Predicate[]{this.elementTypeIs(root, criteriaBuilder, "service-call"), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)"http"), (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationPath"), value)}), criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-sender"), (Expression)conditionPredicateBuilder.apply(criteriaBuilder.function("regexp_replace", String.class, new Expression[]{this.getChainElementPropertyExpression(root, criteriaBuilder, "uri"), criteriaBuilder.literal((Object)"^https?://[^:/]+(:\\d{1,5})?"), criteriaBuilder.literal((Object)"")}), value))});
            case FilterFeature.METHOD -> criteriaBuilder.or(new Predicate[]{criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-sender"), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "httpMethod"), value)), criteriaBuilder.and(new Predicate[]{this.elementTypeIs(root, criteriaBuilder, "service-call"), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)"http"), (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationMethod"), value)}), criteriaBuilder.and((Expression)this.elementTypeIs(root, criteriaBuilder, "http-trigger"), (Expression)this.buildPredicateForHttpTriggerMethod(root, criteriaBuilder, filter.getCondition(), value))});
            case FilterFeature.LABELS -> {
                boolean negativeLabelFilter;
                Predicate predicate = (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "labels").get("name"), value);
                boolean v1 = negativeLabelFilter = filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.DOES_NOT_CONTAIN;
                if (negativeLabelFilter) {
                    yield criteriaBuilder.or((Expression)predicate, (Expression)criteriaBuilder.isNull((Expression)this.getJoin(root, "labels").get("name")));
                }
                yield predicate;
            }
            case FilterFeature.TOPIC -> {
                Function<Root<ChainElement>, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, (Root<ChainElement>)elRoot, criteriaBuilder, conditionPredicateBuilder, "kafka", "integrationOperationPath", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression<?>)elRoot.get("properties"), criteriaBuilder, "topics"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "topics"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case FilterFeature.QUEUE -> {
                Function<Root<ChainElement>, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, (Root<ChainElement>)elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "queues", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression<?>)elRoot.get("properties"), criteriaBuilder, "queues"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "queues"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case FilterFeature.EXCHANGE -> {
                Function<Root<ChainElement>, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or((Expression)this.buildAsyncOperationPredicate(root, (Root<ChainElement>)elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "integrationOperationPath", value), (Expression)(isNegativeElementFilter ? criteriaBuilder.equal(this.getElementPropertyExpression((Expression<?>)elRoot.get("properties"), criteriaBuilder, "exchange"), (Object)value) : (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "exchange"), value)));
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            case FilterFeature.SERVICE_ID -> (Predicate)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationSystemId"), value);
            case FilterFeature.CLASSIFIER -> {
                Function<Root<ChainElement>, Predicate> basePredicateFunc = elRoot -> criteriaBuilder.or(new Predicate[]{this.buildAsyncOperationPredicate(root, (Root<ChainElement>)elRoot, criteriaBuilder, conditionPredicateBuilder, "kafka", "maas.classifier.name", value), this.buildAsyncOperationPredicate(root, (Root<ChainElement>)elRoot, criteriaBuilder, conditionPredicateBuilder, "amqp", "maas.classifier.name", value), isNegativeElementFilter ? criteriaBuilder.or((Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "topicsClassifierName"), (Object)value), (Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "vhostClassifierName"), (Object)value)) : criteriaBuilder.or((Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "topicsClassifierName"), value), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, "vhostClassifierName"), value))});
                if (isNegativeElementFilter) {
                    yield this.getNegativeFilterPredicate(root, criteriaBuilder, basePredicateFunc);
                }
                yield basePredicateFunc.apply(null);
            }
            default -> throw new IllegalStateException("Unexpected filter feature: " + String.valueOf((Object)filter.getFeature()));
        };
    }

    @NotNull
    private Predicate getNegativeFilterPredicate(Root<Chain> root, CriteriaBuilder criteriaBuilder, Function<Root<ChainElement>, Predicate> basePredicateFunc) {
        Subquery negativeSubquery = criteriaBuilder.createQuery().subquery(String.class);
        Root elRoot = negativeSubquery.from(ChainElement.class);
        negativeSubquery.select((Expression)elRoot.get("chain").get("id")).where((Expression)criteriaBuilder.and((Expression)basePredicateFunc.apply((Root<ChainElement>)elRoot), (Expression)criteriaBuilder.isNotNull((Expression)elRoot.get("chain").get("id"))));
        return criteriaBuilder.not((Expression)root.get("id").in(new Expression[]{negativeSubquery}));
    }

    private Predicate buildPredicateForHttpTriggerMethod(Root<Chain> root, CriteriaBuilder criteriaBuilder, FilterCondition condition, String value) {
        Expression<String> methodPropertyExpression = this.getChainElementPropertyExpression(root, criteriaBuilder, "httpMethodRestrict");
        Predicate likeValue = criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value + "%"))));
        return switch (condition) {
            case FilterCondition.IS, FilterCondition.CONTAINS, FilterCondition.IN -> likeValue;
            case FilterCondition.DOES_NOT_CONTAIN, FilterCondition.IS_NOT, FilterCondition.NOT_IN -> criteriaBuilder.not((Expression)likeValue);
            case FilterCondition.STARTS_WITH -> criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)(value + "%"))));
            case FilterCondition.ENDS_WITH -> criteriaBuilder.like(criteriaBuilder.lower(methodPropertyExpression), criteriaBuilder.lower(criteriaBuilder.literal((Object)("%" + value))));
            case FilterCondition.EMPTY -> criteriaBuilder.or((Expression)criteriaBuilder.literal((Object)value).isNull(), (Expression)criteriaBuilder.equal(criteriaBuilder.literal((Object)value), (Object)""));
            case FilterCondition.NOT_EMPTY -> criteriaBuilder.or((Expression)criteriaBuilder.literal((Object)value).isNotNull(), (Expression)criteriaBuilder.notEqual(criteriaBuilder.literal((Object)value), (Object)""));
            default -> throw new IllegalStateException("Unexpected condition value: " + String.valueOf(condition));
        };
    }

    private Predicate buildAsyncOperationPredicate(Root<Chain> root, Root<ChainElement> elRoot, CriteriaBuilder criteriaBuilder, BiFunction<Expression<String>, String, Predicate> conditionPredicateBuilder, String protocol, String operationProperty, String value) {
        return criteriaBuilder.and(new Predicate[]{criteriaBuilder.or((Expression)this.elementTypeIs(root, criteriaBuilder, "service-call"), (Expression)this.elementTypeIs(root, criteriaBuilder, "async-api-trigger")), criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, "integrationOperationProtocolType"), (Object)protocol), elRoot == null ? criteriaBuilder.or((Expression)conditionPredicateBuilder.apply(this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", operationProperty), value), (Expression)conditionPredicateBuilder.apply(this.getChainElementPropertyExpression(root, criteriaBuilder, operationProperty), value)) : criteriaBuilder.or((Expression)criteriaBuilder.equal(this.getChainElementSubPropertyExpression(root, criteriaBuilder, "integrationOperationAsyncProperties", operationProperty), (Object)value), (Expression)criteriaBuilder.equal(this.getChainElementPropertyExpression(root, criteriaBuilder, operationProperty), (Object)value))});
    }

    private Predicate elementTypeIs(Root<Chain> root, CriteriaBuilder criteriaBuilder, String typeName) {
        Join<Chain, ?> elementJoin = this.getJoin(root, "elements");
        return criteriaBuilder.equal((Expression)elementJoin.get("type"), (Object)typeName);
    }

    private Expression<String> getChainElementPropertyExpression(Root<Chain> root, CriteriaBuilder criteriaBuilder, String propertyName) {
        Join<Chain, ?> elementJoin = this.getJoin(root, "elements");
        return this.getElementPropertyExpression((Expression<?>)elementJoin.get("properties"), criteriaBuilder, propertyName);
    }

    private Expression<String> getChainElementSubPropertyExpression(Root<Chain> root, CriteriaBuilder criteriaBuilder, String propertyName, String subPropertyName) {
        Join<Chain, ?> elementJoin = this.getJoin(root, "elements");
        return this.getElementPropertySubParameterExpression((Expression<?>)elementJoin.get("properties"), criteriaBuilder, propertyName, subPropertyName);
    }

    private Expression<String> getElementPropertyExpression(Expression<?> props, CriteriaBuilder criteriaBuilder, String propertyName) {
        return criteriaBuilder.function("jsonb_extract_path_text", String.class, new Expression[]{props, criteriaBuilder.literal((Object)propertyName)});
    }

    private Expression<String> getElementPropertySubParameterExpression(Expression<?> props, CriteriaBuilder criteriaBuilder, String propertyName, String subPropertyName) {
        return criteriaBuilder.function("jsonb_extract_path_text", String.class, new Expression[]{props, criteriaBuilder.literal((Object)propertyName), criteriaBuilder.literal((Object)subPropertyName)});
    }

    private <T> Expression<T> getDeploymentPropertyExpression(Root<Chain> root, String propertyName) {
        Join<Chain, ?> deploymentJoin = this.getJoin(root, "deployments");
        return deploymentJoin.get(propertyName);
    }

    private Join<Chain, ?> getJoin(Root<Chain> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

