/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.instructions.ImportInstruction;
import org.qubership.integration.platform.catalog.service.filter.FilterConditionPredicateBuilderFactory;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class ImportInstructionFilterSpecificationBuilder {
    private final FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory;

    public ImportInstructionFilterSpecificationBuilder(FilterConditionPredicateBuilderFactory filterConditionPredicateBuilderFactory) {
        this.filterConditionPredicateBuilderFactory = filterConditionPredicateBuilderFactory;
    }

    public Specification<ImportInstruction> buildSearch(Collection<FilterRequestDTO> filters) {
        return this.buildFilter(filters, CriteriaBuilder::or);
    }

    public Specification<ImportInstruction> buildFilter(Collection<FilterRequestDTO> filters) {
        return this.buildFilter(filters, CriteriaBuilder::and);
    }

    private Specification<ImportInstruction> buildFilter(Collection<FilterRequestDTO> filters, BiFunction<CriteriaBuilder, Predicate[], Predicate> predicateAccumulator) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            if (CollectionUtils.isEmpty((Collection)filters)) {
                return null;
            }
            Predicate[] predicates = (Predicate[])filters.stream().map(filter -> this.buildPredicate((Root<ImportInstruction>)root, criteriaBuilder, (FilterRequestDTO)filter)).toArray(Predicate[]::new);
            return predicates.length > 1 ? (Predicate)predicateAccumulator.apply(criteriaBuilder, predicates) : predicates[0];
        };
    }

    private Predicate buildPredicate(Root<ImportInstruction> root, CriteriaBuilder criteriaBuilder, FilterRequestDTO filter) {
        BiFunction conditionPredicateBuilder = this.filterConditionPredicateBuilderFactory.getPredicateBuilder(criteriaBuilder, filter.getCondition());
        String filterValue = filter.getValue();
        return switch (filter.getFeature()) {
            case FilterFeature.ID -> (Predicate)conditionPredicateBuilder.apply(root.get("id"), filterValue);
            case FilterFeature.ENTITY_TYPE -> (Predicate)conditionPredicateBuilder.apply(root.get("entityType"), filterValue);
            case FilterFeature.INSTRUCTION_ACTION -> (Predicate)conditionPredicateBuilder.apply(root.get("action"), filterValue);
            case FilterFeature.OVERRIDDEN_BY -> (Predicate)conditionPredicateBuilder.apply(root.get("overriddenBy"), filterValue);
            case FilterFeature.LABELS -> {
                boolean negativeLabelFilter;
                Predicate predicate = (Predicate)conditionPredicateBuilder.apply(this.getJoin(root, "labels").get("name"), filterValue);
                boolean v1 = negativeLabelFilter = filter.getCondition() == FilterCondition.IS_NOT || filter.getCondition() == FilterCondition.DOES_NOT_CONTAIN;
                if (negativeLabelFilter) {
                    yield criteriaBuilder.or((Expression)predicate, (Expression)criteriaBuilder.isNull((Expression)this.getJoin(root, "labels").get("name")));
                }
                yield predicate;
            }
            case FilterFeature.MODIFIED_WHEN -> (Predicate)conditionPredicateBuilder.apply(root.get("modifiedWhen"), filterValue);
            default -> throw new IllegalStateException("Unexpected feature value: " + String.valueOf((Object)filter.getFeature()));
        };
    }

    private Join<ImportInstruction, ?> getJoin(Root<ImportInstruction> root, String attributeName) {
        return root.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).findAny().orElseGet(() -> root.join(attributeName, JoinType.LEFT));
    }
}

