/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.filter.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.qubership.integration.platform.catalog.model.chain.ChainStatus;
import org.qubership.integration.platform.catalog.model.deployment.engine.ChainRuntimeDeployment;
import org.qubership.integration.platform.catalog.model.filter.FilterCondition;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Chain;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Deployment;
import org.qubership.integration.platform.designtime.catalog.model.enums.filter.FilterFeature;
import org.qubership.integration.platform.designtime.catalog.rest.v1.dto.FilterRequestDTO;
import org.qubership.integration.platform.designtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.designtime.catalog.service.filter.complex.FilterApplier;
import org.springframework.util.CollectionUtils;

public class ChainStatusFilters
implements FilterApplier {
    private static final String NO_DEPLOYMENTS_CAPTION = "No deployments yet";
    private final DeploymentService deploymentService;

    public ChainStatusFilters(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public List<Chain> apply(List<Chain> chains, List<FilterRequestDTO> filters) {
        List<FilterRequestDTO> deploymentStatusFilters = filters.stream().map(filter -> FilterFeature.ENGINES.equals((Object)filter.getFeature()) && NO_DEPLOYMENTS_CAPTION.equals(filter.getValue()) ? filter.toBuilder().feature(FilterFeature.STATUS).value(ChainStatus.DRAFT.name()).build() : filter).filter(filter -> FilterFeature.STATUS.equals((Object)filter.getFeature())).toList();
        if (deploymentStatusFilters.isEmpty()) {
            return chains;
        }
        Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments = this.deploymentService.getAllRuntimeDeployments();
        return chains.stream().filter(chain -> deploymentStatusFilters.stream().allMatch(filter -> this.chainMatchesDeploymentStatusFilter(runtimeDeployments, (Chain)chain, (FilterRequestDTO)filter))).toList();
    }

    private boolean chainMatchesDeploymentStatusFilter(Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments, Chain chain, FilterRequestDTO filter) {
        Collection<ChainStatus> chainDeploymentStatuses = this.getChainDeploymentStatuses(runtimeDeployments, chain);
        Predicate<ChainStatus> predicate = this.getDeploymentStatusPredicate(filter);
        return chainDeploymentStatuses.stream().anyMatch(predicate);
    }

    private Collection<ChainStatus> getChainDeploymentStatuses(Map<String, Collection<ChainRuntimeDeployment>> runtimeDeployments, Chain chain) {
        Collection<ChainRuntimeDeployment> chainRuntimeDeployments;
        List deployments = chain.getDeployments();
        Collection<ChainRuntimeDeployment> collection = chainRuntimeDeployments = runtimeDeployments == null ? null : runtimeDeployments.get(chain.getId());
        if (CollectionUtils.isEmpty((Collection)deployments)) {
            return Collections.singletonList(ChainStatus.DRAFT);
        }
        ArrayList<ChainStatus> result = new ArrayList<ChainStatus>();
        for (Deployment deployment : deployments) {
            ChainRuntimeDeployment runtimeDeployment;
            String deploymentId = deployment.getId();
            ChainRuntimeDeployment chainRuntimeDeployment = runtimeDeployment = chainRuntimeDeployments == null ? null : (ChainRuntimeDeployment)chainRuntimeDeployments.stream().filter(dep -> deploymentId.equals(dep.getDeploymentInfo().getDeploymentId())).findAny().orElse(null);
            if (runtimeDeployment != null) {
                result.add(ChainStatus.valueOf((String)runtimeDeployment.getStatus().name()));
                continue;
            }
            result.add(ChainStatus.PROCESSING);
        }
        return result;
    }

    private Predicate<ChainStatus> getDeploymentStatusPredicate(FilterRequestDTO filter) {
        return switch (filter.getCondition()) {
            case FilterCondition.IN -> status -> Arrays.stream(filter.getValue().split(",")).anyMatch(value -> ChainStatus.valueOf((String)value.toUpperCase()) == status);
            case FilterCondition.NOT_IN -> status -> Arrays.stream(filter.getValue().split(",")).noneMatch(value -> ChainStatus.valueOf((String)value.toUpperCase()) == status);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(filter.getCondition()));
        };
    }
}

