/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class MigrationContext {
    public static final String OLD_TRY_CATCH_FINALLY_TYPE = "try-catch-finally";
    public static final String NEW_TRY_CATCH_FINALLY_TYPE = "try-catch-finally-2";
    public static final String OLD_TRY_TYPE = "try";
    public static final String NEW_TRY_TYPE = "try-2";
    public static final String OLD_CATCH_TYPE = "catch";
    public static final String NEW_CATCH_TYPE = "catch-2";
    public static final String OLD_FINALLY_TYPE = "finally";
    public static final String NEW_FINALLY_TYPE = "finally-2";
    public static final String OLD_CHOICE_TYPE = "choice";
    public static final String NEW_CHOICE_TYPE = "condition";
    public static final String OLD_WHEN_TYPE = "when";
    public static final String NEW_WHEN_TYPE = "if";
    public static final String OLD_OTHERWISE_TYPE = "otherwise";
    public static final String NEW_OTHERWISE_TYPE = "else";
    public static final String OLD_LOOP_TYPE = "loop";
    public static final String NEW_LOOP_TYPE = "loop-2";
    public static final String OLD_LOOP_EXPRESSION_TYPE = "loop-expression";
    public static final String OLD_CIRCUIT_BREAKER_TYPE = "circuit-breaker";
    public static final String NEW_CIRCUIT_BREAKER_TYPE = "circuit-breaker-2";
    public static final String OLD_CIRCUIT_BREAKER_CONFIGURATION_TYPE = "circuit-breaker-configuration";
    public static final String NEW_CIRCUIT_BREAKER_CONFIGURATION_TYPE = "circuit-breaker-configuration-2";
    public static final String OLD_ON_FALLBACK_TYPE = "on-fallback";
    public static final String NEW_ON_FALLBACK_TYPE = "on-fallback-2";
    public static final String OLD_SPLIT_TYPE = "split";
    public static final String NEW_SPLIT_TYPE = "split-2";
    public static final String OLD_MAIN_SPLIT_ELEMENT_TYPE = "main-split-element";
    public static final String NEW_MAIN_SPLIT_ELEMENT_TYPE = "main-split-element-2";
    public static final String OLD_SPLIT_ELEMENT_TYPE = "split-element";
    public static final String NEW_SPLIT_ELEMENT_TYPE = "split-element-2";
    public static final String OLD_SPLIT_RESULT_TYPE = "split-result";
    public static final String OLD_SPLIT_ASYNC_TYPE = "split-async";
    public static final String NEW_SPLIT_ASYNC_TYPE = "split-async-2";
    public static final String OLD_ASYNC_SPLIT_ELEMENT_TYPE = "async-split-element";
    public static final String NEW_ASYNC_SPLIT_ELEMENT_TYPE = "async-split-element-2";
    public static final String OLD_SYNC_SPLIT_ELEMENT_TYPE = "sync-split-element";
    public static final String REUSE_REFERENCE_ELEMENT_TYPE = "reuse-reference";
    public static final String REUSE_ELEMENT_TYPE = "reuse";
    public static final String REUSED_ELEMENT = "reused-element";
    public static final String PRIORITY_NUMBER = "priorityNumber";
    public static final String REUSE_ELEMENT_ID = "reuseElementId";
    private final Map<String, ElementMigration> elementMigrations;
    private final Set<String> checkedElementIds = new LinkedHashSet<String>();
    private final Set<String> inProgressElementIds = new LinkedHashSet<String>();
    private final Set<String> inProgressReferenceInputIds = new LinkedHashSet<String>();
    private final Map<String, ChainElement> migratedElements = new HashMap<String, ChainElement>();
    private final Map<String, ContainerChainElement> reuseElements = new HashMap<String, ContainerChainElement>();
    private final List<ChainElement> elementsToDelete = new ArrayList<ChainElement>();
    private final List<ChainElement> groupsToDelete = new ArrayList<ChainElement>();
    private final List<Dependency> dependenciesToDelete = new ArrayList<Dependency>();

    @Nullable
    public ElementMigration getElementMigration(String elementType) {
        return this.elementMigrations.get(elementType);
    }

    public void addMigratedElement(ChainElement migratedElement) {
        this.migratedElements.put(migratedElement.getId(), migratedElement);
    }

    public void addReuseElement(String firstElementId, ContainerChainElement reuseElement) {
        this.reuseElements.put(firstElementId, reuseElement);
    }

    public void addElementToDelete(ChainElement element) {
        this.elementsToDelete.add(element);
    }

    public void addGroupToDelete(ChainElement groupElement) {
        this.groupsToDelete.add(groupElement);
    }

    public void addDependencyToDelete(Dependency dependency) {
        this.dependenciesToDelete.add(dependency);
    }

    public boolean isElementChecked(@NonNull ChainElement element) {
        return this.checkedElementIds.contains(element.getId());
    }

    public boolean isElementMigrationInProgress(@NonNull ChainElement element) {
        return this.inProgressElementIds.contains(element.getId());
    }

    public boolean isReferenceInputInProgress(@NonNull ChainElement element) {
        return this.inProgressReferenceInputIds.contains(element.getId());
    }

    @Generated
    public MigrationContext(Map<String, ElementMigration> elementMigrations) {
        this.elementMigrations = elementMigrations;
    }

    @Generated
    public Map<String, ElementMigration> getElementMigrations() {
        return this.elementMigrations;
    }

    @Generated
    public Set<String> getCheckedElementIds() {
        return this.checkedElementIds;
    }

    @Generated
    public Set<String> getInProgressElementIds() {
        return this.inProgressElementIds;
    }

    @Generated
    public Set<String> getInProgressReferenceInputIds() {
        return this.inProgressReferenceInputIds;
    }

    @Generated
    public Map<String, ChainElement> getMigratedElements() {
        return this.migratedElements;
    }

    @Generated
    public Map<String, ContainerChainElement> getReuseElements() {
        return this.reuseElements;
    }

    @Generated
    public List<ChainElement> getElementsToDelete() {
        return this.elementsToDelete;
    }

    @Generated
    public List<ChainElement> getGroupsToDelete() {
        return this.groupsToDelete;
    }

    @Generated
    public List<Dependency> getDependenciesToDelete() {
        return this.dependenciesToDelete;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationContext)) {
            return false;
        }
        MigrationContext other = (MigrationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ElementMigration> this$elementMigrations = this.getElementMigrations();
        Map<String, ElementMigration> other$elementMigrations = other.getElementMigrations();
        if (this$elementMigrations == null ? other$elementMigrations != null : !((Object)this$elementMigrations).equals(other$elementMigrations)) {
            return false;
        }
        Set<String> this$checkedElementIds = this.getCheckedElementIds();
        Set<String> other$checkedElementIds = other.getCheckedElementIds();
        if (this$checkedElementIds == null ? other$checkedElementIds != null : !((Object)this$checkedElementIds).equals(other$checkedElementIds)) {
            return false;
        }
        Set<String> this$inProgressElementIds = this.getInProgressElementIds();
        Set<String> other$inProgressElementIds = other.getInProgressElementIds();
        if (this$inProgressElementIds == null ? other$inProgressElementIds != null : !((Object)this$inProgressElementIds).equals(other$inProgressElementIds)) {
            return false;
        }
        Set<String> this$inProgressReferenceInputIds = this.getInProgressReferenceInputIds();
        Set<String> other$inProgressReferenceInputIds = other.getInProgressReferenceInputIds();
        if (this$inProgressReferenceInputIds == null ? other$inProgressReferenceInputIds != null : !((Object)this$inProgressReferenceInputIds).equals(other$inProgressReferenceInputIds)) {
            return false;
        }
        Map<String, ChainElement> this$migratedElements = this.getMigratedElements();
        Map<String, ChainElement> other$migratedElements = other.getMigratedElements();
        if (this$migratedElements == null ? other$migratedElements != null : !((Object)this$migratedElements).equals(other$migratedElements)) {
            return false;
        }
        Map<String, ContainerChainElement> this$reuseElements = this.getReuseElements();
        Map<String, ContainerChainElement> other$reuseElements = other.getReuseElements();
        if (this$reuseElements == null ? other$reuseElements != null : !((Object)this$reuseElements).equals(other$reuseElements)) {
            return false;
        }
        List<ChainElement> this$elementsToDelete = this.getElementsToDelete();
        List<ChainElement> other$elementsToDelete = other.getElementsToDelete();
        if (this$elementsToDelete == null ? other$elementsToDelete != null : !((Object)this$elementsToDelete).equals(other$elementsToDelete)) {
            return false;
        }
        List<ChainElement> this$groupsToDelete = this.getGroupsToDelete();
        List<ChainElement> other$groupsToDelete = other.getGroupsToDelete();
        if (this$groupsToDelete == null ? other$groupsToDelete != null : !((Object)this$groupsToDelete).equals(other$groupsToDelete)) {
            return false;
        }
        List<Dependency> this$dependenciesToDelete = this.getDependenciesToDelete();
        List<Dependency> other$dependenciesToDelete = other.getDependenciesToDelete();
        return !(this$dependenciesToDelete == null ? other$dependenciesToDelete != null : !((Object)this$dependenciesToDelete).equals(other$dependenciesToDelete));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrationContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ElementMigration> $elementMigrations = this.getElementMigrations();
        result = result * 59 + ($elementMigrations == null ? 43 : ((Object)$elementMigrations).hashCode());
        Set<String> $checkedElementIds = this.getCheckedElementIds();
        result = result * 59 + ($checkedElementIds == null ? 43 : ((Object)$checkedElementIds).hashCode());
        Set<String> $inProgressElementIds = this.getInProgressElementIds();
        result = result * 59 + ($inProgressElementIds == null ? 43 : ((Object)$inProgressElementIds).hashCode());
        Set<String> $inProgressReferenceInputIds = this.getInProgressReferenceInputIds();
        result = result * 59 + ($inProgressReferenceInputIds == null ? 43 : ((Object)$inProgressReferenceInputIds).hashCode());
        Map<String, ChainElement> $migratedElements = this.getMigratedElements();
        result = result * 59 + ($migratedElements == null ? 43 : ((Object)$migratedElements).hashCode());
        Map<String, ContainerChainElement> $reuseElements = this.getReuseElements();
        result = result * 59 + ($reuseElements == null ? 43 : ((Object)$reuseElements).hashCode());
        List<ChainElement> $elementsToDelete = this.getElementsToDelete();
        result = result * 59 + ($elementsToDelete == null ? 43 : ((Object)$elementsToDelete).hashCode());
        List<ChainElement> $groupsToDelete = this.getGroupsToDelete();
        result = result * 59 + ($groupsToDelete == null ? 43 : ((Object)$groupsToDelete).hashCode());
        List<Dependency> $dependenciesToDelete = this.getDependenciesToDelete();
        result = result * 59 + ($dependenciesToDelete == null ? 43 : ((Object)$dependenciesToDelete).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MigrationContext(elementMigrations=" + String.valueOf(this.getElementMigrations()) + ", checkedElementIds=" + String.valueOf(this.getCheckedElementIds()) + ", inProgressElementIds=" + String.valueOf(this.getInProgressElementIds()) + ", inProgressReferenceInputIds=" + String.valueOf(this.getInProgressReferenceInputIds()) + ", migratedElements=" + String.valueOf(this.getMigratedElements()) + ", reuseElements=" + String.valueOf(this.getReuseElements()) + ", elementsToDelete=" + String.valueOf(this.getElementsToDelete()) + ", groupsToDelete=" + String.valueOf(this.getGroupsToDelete()) + ", dependenciesToDelete=" + String.valueOf(this.getDependenciesToDelete()) + ")";
    }
}

