/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.AbstractEntity;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.DistinctByKey;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public abstract class RestrictedContainerMigration
extends ElementMigration {
    protected RestrictedContainerMigration(LibraryElementsService libraryService, String oldElementType, String newElementType) {
        super(libraryService, oldElementType, newElementType);
    }

    @Override
    public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
        if (context.isElementChecked(chainElement)) {
            return true;
        }
        if (!(chainElement instanceof ContainerChainElement)) {
            return false;
        }
        context.getCheckedElementIds().add(chainElement.getId());
        return ((ContainerChainElement)chainElement).getElements().stream().filter(element -> !this.isElementDeprecated(element.getType())).allMatch(element -> Optional.ofNullable(context.getElementMigration(element.getType())).map(elementMigration -> elementMigration.canBeMigrated((ChainElement)element, context)).orElse(false));
    }

    @Override
    public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
        context.getInProgressElementIds().add(chainElement.getId());
        ContainerChainElement containerElement = (ContainerChainElement)chainElement;
        LinkedList<ChainElement> newChildren = new LinkedList<ChainElement>();
        LinkedList<ChainElement> deprecatedChildren = new LinkedList<ChainElement>();
        for (ChainElement child : containerElement.getElements()) {
            if (this.isElementDeprecated(child.getType())) {
                deprecatedChildren.add(child);
                continue;
            }
            ElementMigration elementMigration = context.getElementMigration(child.getType());
            if (elementMigration == null) continue;
            newChildren.add(elementMigration.migrate(child, context));
        }
        for (ChainElement deprecatedChild : deprecatedChildren) {
            this.migrateDeprecatedChild(containerElement, deprecatedChild, context);
            context.addElementToDelete(deprecatedChild);
        }
        containerElement.getElements().clear();
        containerElement.setType(this.getNewElementType());
        containerElement.addChildrenElements(newChildren);
        containerElement = this.postMigration(containerElement, context);
        context.getInProgressElementIds().remove(chainElement.getId());
        this.migrateNextElements((ChainElement)containerElement, context);
        return containerElement;
    }

    protected boolean isElementDeprecated(String elementType) {
        return false;
    }

    protected ContainerChainElement postMigration(ContainerChainElement containerElement, MigrationContext context) {
        return containerElement;
    }

    protected void migrateDeprecatedChild(ContainerChainElement parentElement, ChainElement deprecatedChild, MigrationContext context) {
        List<ChainElement> parentOutputElements = parentElement.getOutputDependencies().stream().peek(dependency -> dependency.getElementTo().getInputDependencies().remove(dependency)).peek(context::addDependencyToDelete).map(Dependency::getElementTo).toList();
        parentElement.getOutputDependencies().clear();
        for (Dependency outputDependency : deprecatedChild.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            Dependency newDependency = Dependency.of((ChainElement)parentElement, (ChainElement)elementTo);
            parentElement.addOutputDependency(newDependency);
            elementTo.getInputDependencies().remove(outputDependency);
            elementTo.addInputDependency(newDependency);
        }
        this.extractBranchEndElements(deprecatedChild).stream().filter(DistinctByKey.newInstance(AbstractEntity::getId)).forEach(endElement -> {
            for (ChainElement parentOutputElement : parentOutputElements) {
                Dependency newDependency = Dependency.of((ChainElement)endElement, (ChainElement)parentOutputElement);
                endElement.addOutputDependency(newDependency);
                parentOutputElement.addInputDependency(newDependency);
            }
        });
    }

    private List<ChainElement> extractBranchEndElements(ChainElement chainElement) {
        ArrayList<ChainElement> branchEndElements = new ArrayList<ChainElement>();
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            if (elementTo.getOutputDependencies().isEmpty()) {
                branchEndElements.add(elementTo);
                continue;
            }
            branchEndElements.addAll(this.extractBranchEndElements(elementTo));
        }
        return branchEndElements;
    }

    @Component
    public static class SplitAsyncMigration
    extends RestrictedContainerMigration {
        @Autowired
        public SplitAsyncMigration(LibraryElementsService libraryService) {
            super(libraryService, "split-async", "split-async-2");
        }

        @Override
        public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
            if (!super.canBeMigrated(chainElement, context)) {
                return false;
            }
            long syncSplitCount = ((ContainerChainElement)chainElement).getElements().stream().filter(element -> this.isElementDeprecated(element.getType())).count();
            return syncSplitCount <= 1L;
        }

        @Override
        protected boolean isElementDeprecated(String elementType) {
            return "sync-split-element".equals(elementType);
        }
    }

    @Component
    public static class SplitMigration
    extends RestrictedContainerMigration {
        @Autowired
        public SplitMigration(LibraryElementsService libraryService) {
            super(libraryService, "split", "split-2");
        }

        @Override
        public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
            if (!super.canBeMigrated(chainElement, context)) {
                return false;
            }
            long splitResultCount = ((ContainerChainElement)chainElement).getElements().stream().filter(element -> this.isElementDeprecated(element.getType())).count();
            return splitResultCount <= 1L;
        }

        @Override
        protected boolean isElementDeprecated(String elementType) {
            return "split-result".equals(elementType);
        }
    }

    @Component
    public static class CircuitBreakerMigration
    extends RestrictedContainerMigration {
        @Autowired
        public CircuitBreakerMigration(LibraryElementsService libraryService) {
            super(libraryService, "circuit-breaker", "circuit-breaker-2");
        }
    }

    @Component
    public static class ChoiceMigration
    extends RestrictedContainerMigration {
        @Autowired
        public ChoiceMigration(LibraryElementsService libraryService) {
            super(libraryService, "choice", "condition");
        }

        @Override
        protected ContainerChainElement postMigration(ContainerChainElement containerElement, MigrationContext context) {
            List<ChainElement> whenChildren = containerElement.getElements().stream().filter(element -> "if".equals(element.getType())).sorted((left, right) -> {
                int rightPriority;
                int leftPriority = NumberUtils.toInt((String)left.getPropertyAsString("priorityNumber"), (int)0);
                if (leftPriority == (rightPriority = NumberUtils.toInt((String)right.getPropertyAsString("priorityNumber"), (int)0))) {
                    return 0;
                }
                return leftPriority > rightPriority ? 1 : -1;
            }).toList();
            ElementDescriptor whenDescriptor = this.libraryService.getElementDescriptor("if");
            for (int i = 0; i < whenChildren.size(); ++i) {
                ChainElement catchElement = whenChildren.get(i);
                catchElement.getProperties().remove("priorityNumber");
                whenChildren.get(i).getProperties().put(whenDescriptor.getPriorityProperty(), i);
            }
            return containerElement;
        }
    }

    @Component
    public static class TryCatchFinallyMigration
    extends RestrictedContainerMigration {
        @Autowired
        public TryCatchFinallyMigration(LibraryElementsService libraryService) {
            super(libraryService, "try-catch-finally", "try-catch-finally-2");
        }

        @Override
        protected ContainerChainElement postMigration(ContainerChainElement containerElement, MigrationContext context) {
            List<ChainElement> catchElements = containerElement.getElements().stream().filter(element -> "catch-2".equals(element.getType())).sorted((left, right) -> {
                int rightPriority;
                int leftPriority = NumberUtils.toInt((String)left.getPropertyAsString("priorityNumber"), (int)0);
                if (leftPriority == (rightPriority = NumberUtils.toInt((String)right.getPropertyAsString("priorityNumber"), (int)0))) {
                    return 0;
                }
                return leftPriority > rightPriority ? 1 : -1;
            }).toList();
            ElementDescriptor newCatchDescriptor = this.libraryService.getElementDescriptor("catch-2");
            for (int i = 0; i < catchElements.size(); ++i) {
                ChainElement catchElement = catchElements.get(i);
                catchElement.getProperties().remove("priorityNumber");
                catchElement.getProperties().put(newCatchDescriptor.getPriorityProperty(), i);
            }
            return containerElement;
        }
    }
}

