/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReusedElementMigration
extends ElementMigration {
    @Autowired
    protected ReusedElementMigration(LibraryElementsService libraryService) {
        super(libraryService, "reused-element", "reuse");
    }

    @Override
    public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
        return true;
    }

    @Override
    @Transactional
    public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
        ContainerChainElement reuseElement;
        String originalElementToId = chainElement.getId();
        if (context.getReuseElements().containsKey(originalElementToId)) {
            reuseElement = context.getReuseElements().get(originalElementToId);
        } else {
            reuseElement = this.createReuseElement(chainElement);
            context.addReuseElement(originalElementToId, reuseElement);
            chainElement.getChain().addElement((ChainElement)reuseElement);
            chainElement.getChain().getElements().remove(chainElement);
            ElementMigration elementMigration = context.getElementMigration(chainElement.getType());
            if (elementMigration != null && !context.isElementMigrationInProgress(chainElement)) {
                chainElement = elementMigration.migrate(chainElement, context);
            }
            reuseElement.addChildElement(chainElement);
            LinkedList<ChainElement> outputElements = new LinkedList<ChainElement>();
            outputElements.offer(chainElement);
            while (!outputElements.isEmpty()) {
                ChainElement outputElement = (ChainElement)outputElements.poll();
                for (Dependency outputDependency : new ArrayList(outputElement.getOutputDependencies())) {
                    ChainElement outputElementTo = outputDependency.getElementTo();
                    this.removeElementFromParentGroupIfRequired(outputElementTo, context);
                    if (outputElementTo.getInputDependencies().size() > 1 || context.getReuseElements().containsKey(outputElementTo.getId())) {
                        ChainElement outputReferenceElement = this.replaceReusedElementWithReference(outputElement, outputElementTo, context);
                        reuseElement.addChildElement(outputReferenceElement);
                        continue;
                    }
                    ElementMigration outputElementMigration = context.getElementMigration(outputElementTo.getType());
                    if (outputElementMigration != null && !context.isElementMigrationInProgress(outputElementTo)) {
                        outputElementTo = outputElementMigration.migrate(outputElementTo, context);
                    }
                    reuseElement.addChildElement(outputElementTo);
                    outputElementTo.getChain().getElements().remove(outputElementTo);
                    outputElements.offer(outputElementTo);
                }
            }
        }
        return this.createReferenceElement((ChainElement)reuseElement);
    }

    protected ContainerChainElement createReuseElement(ChainElement startElement) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(this.getNewElementType());
        return ((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)((ContainerChainElement.ContainerChainElementBuilder)ContainerChainElement.builder().type(descriptor.getName())).name(startElement.getName())).chain(startElement.getChain())).build();
    }

    protected ChainElement createReferenceElement(ChainElement reuseElement) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor("reuse-reference");
        return ((ChainElement.ChainElementBuilder)ChainElement.builder().type(descriptor.getName()).name(descriptor.getTitle())).chain(reuseElement.getChain()).properties(Map.of("reuseElementId", reuseElement.getId())).build();
    }
}

