/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.service.migration.element;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.ElementMigration;
import org.qubership.integration.platform.designtime.catalog.service.migration.element.MigrationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public abstract class SimpleContainerMigration
extends ElementMigration {
    protected SimpleContainerMigration(LibraryElementsService libraryService, String oldElementType, String newElementType) {
        super(libraryService, oldElementType, newElementType);
    }

    @Override
    public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
        ElementDescriptor descriptor = this.libraryService.getElementDescriptor(this.getNewElementType());
        if (descriptor == null) {
            return false;
        }
        return this.isOutputDependenciesValid(chainElement, context);
    }

    @Override
    public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
        List<ChainElement> children = this.collectChildren(chainElement, context);
        ContainerChainElement newChainElement = this.buildContainerFromChainElement(chainElement);
        newChainElement.setType(this.getNewElementType());
        newChainElement.addChildrenElements(children);
        context.addElementToDelete(chainElement);
        context.addMigratedElement((ChainElement)newChainElement);
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            outputDependency.getElementTo().getInputDependencies().removeIf(dependency -> StringUtils.equals((CharSequence)dependency.getElementFrom().getId(), (CharSequence)chainElement.getId()));
        }
        return newChainElement;
    }

    private boolean isOutputDependenciesValid(ChainElement chainElement, MigrationContext context) {
        for (Dependency outputDependency : chainElement.getOutputDependencies()) {
            ChainElement elementTo = outputDependency.getElementTo();
            ElementMigration elementMigration = context.getElementMigration(elementTo.getType());
            if (elementMigration != null && !elementMigration.canBeMigrated(elementTo, context)) {
                return false;
            }
            if (this.isOutputDependenciesValid(elementTo, context)) continue;
            return false;
        }
        return true;
    }

    @Component
    public static class AsyncSplitElementMigration
    extends SimpleContainerMigration {
        @Autowired
        public AsyncSplitElementMigration(LibraryElementsService libraryService) {
            super(libraryService, "async-split-element", "async-split-element-2");
        }
    }

    @Component
    public static class SplitElementMigration
    extends SimpleContainerMigration {
        @Autowired
        public SplitElementMigration(LibraryElementsService libraryService) {
            super(libraryService, "split-element", "split-element-2");
        }
    }

    @Component
    public static class MainSplitElementMigration
    extends SimpleContainerMigration {
        @Autowired
        public MainSplitElementMigration(LibraryElementsService libraryService) {
            super(libraryService, "main-split-element", "main-split-element-2");
        }
    }

    @Component
    public static class OnFallbackMigration
    extends SimpleContainerMigration {
        @Autowired
        public OnFallbackMigration(LibraryElementsService libraryService) {
            super(libraryService, "on-fallback", "on-fallback-2");
        }
    }

    @Component
    public static class CircuitBreakerConfigurationMigration
    extends SimpleContainerMigration {
        @Autowired
        public CircuitBreakerConfigurationMigration(LibraryElementsService libraryService) {
            super(libraryService, "circuit-breaker-configuration", "circuit-breaker-configuration-2");
        }
    }

    @Component
    public static class LoopMigration
    extends SimpleContainerMigration {
        @Autowired
        public LoopMigration(LibraryElementsService libraryService) {
            super(libraryService, "loop", "loop-2");
        }

        @Override
        public boolean canBeMigrated(ChainElement chainElement, MigrationContext context) {
            if (!(chainElement instanceof ContainerChainElement)) {
                return false;
            }
            ContainerChainElement containerElement = (ContainerChainElement)chainElement;
            return containerElement.getElements().size() == 1 && super.canBeMigrated((ChainElement)containerElement.getElements().get(0), context);
        }

        @Override
        public ChainElement migrate(ChainElement chainElement, MigrationContext context) {
            context.getInProgressElementIds().add(chainElement.getId());
            ContainerChainElement loopContainer = (ContainerChainElement)chainElement;
            ChainElement loopExpression = (ChainElement)loopContainer.getElements().get(0);
            List<ChainElement> newChildren = this.collectChildren(loopExpression, context);
            loopContainer.setType(this.getNewElementType());
            loopContainer.setProperties(loopExpression.getProperties());
            loopContainer.addChildrenElements(newChildren);
            for (Dependency outputDependency : loopExpression.getOutputDependencies()) {
                outputDependency.getElementTo().getInputDependencies().removeIf(dependency -> StringUtils.equals((CharSequence)dependency.getElementFrom().getId(), (CharSequence)loopExpression.getId()));
            }
            loopContainer.removeChildElement(loopExpression);
            context.addElementToDelete(loopExpression);
            context.getInProgressElementIds().remove(chainElement.getId());
            this.migrateNextElements((ChainElement)loopContainer, context);
            return loopContainer;
        }
    }

    @Component
    public static class OtherwiseMigration
    extends SimpleContainerMigration {
        @Autowired
        public OtherwiseMigration(LibraryElementsService libraryService) {
            super(libraryService, "otherwise", "else");
        }
    }

    @Component
    public static class WhenMigration
    extends SimpleContainerMigration {
        @Autowired
        public WhenMigration(LibraryElementsService libraryService) {
            super(libraryService, "when", "if");
        }
    }

    @Component
    public static class FinallyMigration
    extends SimpleContainerMigration {
        @Autowired
        public FinallyMigration(LibraryElementsService libraryService) {
            super(libraryService, "finally", "finally-2");
        }
    }

    @Component
    public static class CatchMigration
    extends SimpleContainerMigration {
        @Autowired
        public CatchMigration(LibraryElementsService libraryService) {
            super(libraryService, "catch", "catch-2");
        }
    }

    @Component
    public static class TryMigration
    extends SimpleContainerMigration {
        @Autowired
        public TryMigration(LibraryElementsService libraryService) {
            super(libraryService, "try", "try-2");
        }
    }
}

