/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.designtime.catalog.utils;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;

public class OrderedElementUtils {
    private final ElementDescriptor elementDescriptor;
    private final ChainElement orderedElement;

    public OrderedElementUtils(ElementDescriptor elementDescriptor, ChainElement orderedElement) {
        this.elementDescriptor = elementDescriptor;
        this.orderedElement = orderedElement;
    }

    public List<ChainElement> extractOrderedElements(ContainerChainElement parentElement, boolean excludeCurrentElement) {
        return parentElement.getElements().stream().filter(it -> StringUtils.equals((CharSequence)it.getType(), (CharSequence)this.orderedElement.getType())).filter(it -> excludeCurrentElement && !StringUtils.equals((CharSequence)it.getId(), (CharSequence)this.orderedElement.getId())).toList();
    }

    public List<ChainElement> getSortedChildren(ContainerChainElement parentElement) {
        return parentElement.getElements().stream().filter(it -> StringUtils.equals((CharSequence)it.getType(), (CharSequence)this.orderedElement.getType())).sorted((left, right) -> {
            Integer rightPriorityNumber;
            Integer leftPriorityNumber = this.getPriorityAsInt((ChainElement)left);
            if (leftPriorityNumber.equals(rightPriorityNumber = this.getPriorityAsInt((ChainElement)right))) {
                return 0;
            }
            return leftPriorityNumber > rightPriorityNumber ? 1 : -1;
        }).toList();
    }

    public Integer getCurrentElementIndex(List<ChainElement> sortedElements) {
        return sortedElements.stream().filter(it -> StringUtils.equals((CharSequence)it.getId(), (CharSequence)this.orderedElement.getId())).findFirst().map(sortedElements::indexOf).orElse(-1);
    }

    public Integer getIndexByPriority(List<ChainElement> sortedElements, Integer priority) {
        return sortedElements.stream().filter(it -> Objects.equals(this.getPriorityAsInt((ChainElement)it), priority)).findFirst().map(sortedElements::indexOf).orElse(-1);
    }

    public Integer getPriorityAsInt(ChainElement element) {
        Object priority = element.getProperty(this.elementDescriptor.getPriorityProperty());
        return OrderedElementUtils.convertPriorityToInt(priority);
    }

    public void updatePriority(ChainElement element, Integer priority) {
        element.getProperties().put(this.elementDescriptor.getPriorityProperty(), priority);
    }

    public static Integer convertPriorityToInt(Object priority) {
        try {
            return Integer.parseInt(String.valueOf(priority));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Priority number must be an integer: " + String.valueOf(priority), e);
        }
    }
}

