/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.idempotency;

import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.qubership.integration.platform.engine.service.IdempotencyRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="idempotentRepository")
public class PostgresIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private static final Logger log = LoggerFactory.getLogger(PostgresIdempotentRepository.class);
    private static final Integer DEFAULT_KEY_EXPIRY = 600;
    private static final String EXPIRY_PROPERTY = "systemProperty_keyExpiry";
    private final IdempotencyRecordService idempotencyRecordService;

    @Autowired
    public PostgresIdempotentRepository(IdempotencyRecordService idempotencyRecordService) {
        this.idempotencyRecordService = idempotencyRecordService;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        return this.addKeyToStore(key, DEFAULT_KEY_EXPIRY.intValue());
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(Exchange exchange, String key) {
        int ttl = (Integer)exchange.getProperty(EXPIRY_PROPERTY, (Object)DEFAULT_KEY_EXPIRY, Integer.class);
        if (ttl <= 0) {
            throw new IllegalArgumentException("TTL must be greater than 0");
        }
        return this.addKeyToStore(key, ttl);
    }

    private boolean addKeyToStore(String key, int ttl) {
        return this.idempotencyRecordService.insertIfNotExists(key, ttl);
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.idempotencyRecordService.exists(key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        return this.idempotencyRecordService.delete(key);
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
    }

    public boolean confirm(String key) {
        return true;
    }
}

