/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.rabbitmq.client.LongString;
import java.io.IOException;
import java.sql.SQLException;
import java.util.stream.IntStream;
import org.postgresql.jdbc.PgArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgArraySerializer
extends StdSerializer<PgArray> {
    private static final Logger log = LoggerFactory.getLogger(PgArraySerializer.class);

    public PgArraySerializer(Class<PgArray> t) {
        super(t);
    }

    public void serialize(PgArray value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        try {
            Object convertedArray = value.getArray();
            if (convertedArray instanceof String[]) {
                String[] array = (String[])convertedArray;
                generator.writeArray(array, 0, array.length);
                return;
            }
            if (convertedArray instanceof int[]) {
                int[] array = (int[])convertedArray;
                generator.writeArray(array, 0, array.length);
                return;
            }
            if (convertedArray instanceof long[]) {
                long[] array = (long[])convertedArray;
                generator.writeArray(array, 0, array.length);
                return;
            }
            if (convertedArray instanceof double[]) {
                double[] array = (double[])convertedArray;
                generator.writeArray(array, 0, array.length);
                return;
            }
            if (convertedArray instanceof float[]) {
                float[] array = (float[])convertedArray;
                generator.writeArray(IntStream.range(0, array.length).mapToDouble(i -> array[i]).toArray(), 0, array.length);
                return;
            }
            throw new IOException("Failed to serialize PgArray object, invalid array type: " + convertedArray.getClass().getName());
        }
        catch (IOException e) {
            log.warn("Exception while serializing {} object", (Object)LongString.class.getName(), (Object)e);
            throw e;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

