/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.datasource;

import jakarta.annotation.PostConstruct;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.qubership.integration.platform.engine.configuration.datasource.PersistenceCheckpointAutoConfiguration;
import org.qubership.integration.platform.engine.configuration.datasource.PersistenceQuartzAutoConfiguration;
import org.qubership.integration.platform.engine.configuration.datasource.properties.FlywayConfigProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@AutoConfiguration
@ConditionalOnProperty(name={"qip.flyway-initializer.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={PersistenceCheckpointAutoConfiguration.class, PersistenceQuartzAutoConfiguration.class})
@EnableConfigurationProperties(value={FlywayConfigProperties.class})
public class FlywayInitializer {
    private final DataSource checkpointDataSource;
    private final DataSource qrtzDataSource;
    private final FlywayConfigProperties properties;

    public FlywayInitializer(@Qualifier(value="checkpointDataSource") DataSource checkpointDataSource, @Qualifier(value="qrtzDataSource") DataSource qrtzDataSource, FlywayConfigProperties properties) {
        this.checkpointDataSource = checkpointDataSource;
        this.qrtzDataSource = qrtzDataSource;
        this.properties = properties;
    }

    @PostConstruct
    public void migrate() {
        ClassicConfiguration ckptConfig = this.properties.getConfig("checkpoints-datasource");
        ckptConfig.setDataSource(this.checkpointDataSource);
        Flyway checkpointsFlyway = new Flyway((Configuration)ckptConfig);
        checkpointsFlyway.migrate();
        ClassicConfiguration qrtzConfig = this.properties.getConfig("qrtz-datasource");
        qrtzConfig.setDataSource(this.qrtzDataSource);
        Flyway qrtzFlyway = new Flyway((Configuration)qrtzConfig);
        qrtzFlyway.migrate();
    }
}

