/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.MicrometerMetricsCollector;
import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.components.rabbitmq.NoOpMetricsCollector;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.ChainElementTypeHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.MetricTagsHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
public class AmpqDependencyBinder
extends ElementProcessingAction {
    private final MetricsStore metricsStore;
    private final MetricTagsHelper metricTagsHelper;

    @Autowired
    public AmpqDependencyBinder(MetricsStore metricsStore, MetricTagsHelper metricTagsHelper) {
        this.metricsStore = metricsStore;
        this.metricTagsHelper = metricTagsHelper;
    }

    public boolean applicableTo(ElementProperties properties) {
        String elementType = (String)properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return ChainElementType.isAmqpAsyncElement((ChainElementType)chainElementType) && (!ChainElementTypeHelper.isServiceCallOrAsyncApiTrigger((ChainElementType)chainElementType) || "amqp".equals(properties.getProperties().get("integrationOperationProtocolType")));
    }

    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        Collection tags = this.metricTagsHelper.buildMetricTagsLegacy(deploymentInfo, properties, deploymentInfo.getChainName());
        String maasClassifier = (String)properties.getProperties().get("maasClassifier");
        if (!StringUtils.isEmpty((CharSequence)maasClassifier)) {
            tags.add(Tag.of((String)"maas_classifier", (String)maasClassifier));
        }
        MicrometerMetricsCollector metricsCollector = this.metricsStore.isMetricsEnabled() ? new MicrometerMetricsCollector(this.metricsStore.getMeterRegistry(), "rabbitmq", (Iterable)tags) : new NoOpMetricsCollector();
        String elementId = properties.getElementId();
        context.getRegistry().bind(elementId, MetricsCollector.class, (Object)metricsCollector);
    }
}

