/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.StdScheduler;

public class StdSchedulerProxy
extends StdScheduler {
    private final Object lock = new Object();
    private final ConcurrentMap<Thread, List<Pair<JobDetail, Trigger>>> delayedScheduledJobsMap = new ConcurrentHashMap<Thread, List<Pair<JobDetail, Trigger>>>();
    private boolean isSuspended = false;

    public StdSchedulerProxy(QuartzScheduler sched) {
        super(sched);
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.getDelayedScheduledJobs().add((Pair<JobDetail, Trigger>)Pair.of((Object)jobDetail, (Object)trigger));
        return new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SchedulerException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSuspended) {
                super.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDelayed(int seconds) throws SchedulerException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSuspended) {
                super.startDelayed(seconds);
            }
        }
    }

    public void shutdown(boolean waitForJobsToComplete) {
    }

    public void commitScheduledJobs() throws SchedulerException {
        for (Pair<JobDetail, Trigger> pair : this.getDelayedScheduledJobs()) {
            super.scheduleJob((JobDetail)pair.getLeft(), Set.of((Trigger)pair.getRight()), true);
        }
        this.clearDelayedJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendScheduler() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSuspended) {
                this.isSuspended = true;
                if (!super.isInStandbyMode()) {
                    super.standby();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScheduler() throws SchedulerException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSuspended) {
                this.startAndResumeJobs();
                this.isSuspended = false;
            }
        }
    }

    private void startAndResumeJobs() throws SchedulerException {
        super.start();
        super.resumeAll();
    }

    public void clearDelayedJobs() {
        this.getDelayedScheduledJobs().clear();
    }

    private List<Pair<JobDetail, Trigger>> getDelayedScheduledJobs() {
        return this.delayedScheduledJobsMap.computeIfAbsent(Thread.currentThread(), thread -> new ArrayList(8));
    }
}

