/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import java.util.List;
import org.qubership.integration.platform.engine.rest.v1.dto.LiveExchangeDTO;
import org.qubership.integration.platform.engine.service.LiveExchangesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/v1/engine/live-exchanges"}, produces={"application/json"})
@Tag(name="live-exchanges-controller", description="Live Exchanges Controller")
public class LiveExchangesController {
    private static final Logger log = LoggerFactory.getLogger(LiveExchangesController.class);
    private final LiveExchangesService liveExchangesService;

    @Autowired
    public LiveExchangesController(LiveExchangesService liveExchangesService) {
        this.liveExchangesService = liveExchangesService;
    }

    @GetMapping
    @Operation(description="Get top N running exchanges ordered by execution time DESC")
    public ResponseEntity<List<LiveExchangeDTO>> getLiveExchanges(@RequestParam(required=false, defaultValue="10") @Positive @Parameter(description="Amount of exchanges to view") Integer limit) {
        List<LiveExchangeDTO> result = this.liveExchangesService.getTopLiveExchanges(limit);
        if (CollectionUtils.isEmpty(result)) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(result);
    }

    @DeleteMapping(value={"/{deploymentId}/{exchangeId}"})
    @Operation(description="Try to kill specified exchange")
    public ResponseEntity<Void> killExchange(@PathVariable @NotBlank @Parameter(description="Deployment ID") String deploymentId, @PathVariable @NotBlank @Parameter(description="Exchange ID") String exchangeId) {
        this.liveExchangesService.killLiveExchangeById(deploymentId, exchangeId);
        return ResponseEntity.accepted().build();
    }
}

