/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.xml;

import io.atlasmap.api.AtlasException;
import io.atlasmap.xml.core.XmlFieldWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QipAtlasXmlFieldWriter
extends XmlFieldWriter {
    public QipAtlasXmlFieldWriter(ClassLoader classLoader, Map<String, String> namespaces, String seedDocument) throws AtlasException {
        super(classLoader, namespaces, seedDocument);
    }

    protected void seedDocumentNamespaces(Document document) {
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashMap();
        }
        NodeList nodeList = document.getChildNodes();
        this.addNamespacesFromNodes(nodeList);
    }

    private void addNamespacesFromNodes(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int x = 0; x < namedNodeMap.getLength(); ++x) {
                Node attribute = namedNodeMap.item(x);
                if (attribute.getNamespaceURI() != null) {
                    if (attribute.getLocalName().equals("xmlns")) {
                        this.namespaces.put("", attribute.getNodeValue());
                        continue;
                    }
                    this.namespaces.put(attribute.getLocalName(), attribute.getNodeValue());
                    continue;
                }
                if (attribute.getNodeName().equals("xmlns")) {
                    this.namespaces.put("", attribute.getNodeValue());
                    continue;
                }
                if (!attribute.getNodeName().startsWith("xmlns:")) continue;
                String alias = attribute.getNodeName().substring("xmlns:".length());
                this.namespaces.put(alias, attribute.getNodeValue());
            }
            this.addNamespacesFromNodes(node.getChildNodes());
        }
    }
}

