/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.configuration.NamespaceProvider;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.errorhandling.KubeApiException;
import org.qubership.integration.platform.engine.events.CommonVariablesUpdatedEvent;
import org.qubership.integration.platform.engine.events.SecuredVariablesUpdatedEvent;
import org.qubership.integration.platform.engine.kubernetes.KubeOperator;
import org.qubership.integration.platform.engine.service.MergedVariablesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class VariablesService {
    private static final Logger log = LoggerFactory.getLogger(VariablesService.class);
    private final String kubeSecretV2Name;
    private final Pair<String, String> kubeSecretsLabel;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("#\\{[a-zA-Z0-9:._-]+\\}");
    private static final String SECRET_VARIABLE_SEPARATOR = ":";
    public static final String NAMESPACE_VARIABLE = "namespace";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ApplicationEventPublisher applicationEventPublisher;
    private final KubeOperator operator;
    private final NamespaceProvider namespaceProvider;
    private Map<String, String> commonVariables = Collections.emptyMap();
    private Map<String, String> securedVariables = Collections.emptyMap();
    private Map<String, String> mergedVariables = Collections.emptyMap();
    private StringSubstitutor substitutor;
    private StringSubstitutor substitutorEscaped;
    private boolean isInitialSecuredEvent = true;
    private boolean isInitialCommonEvent = true;

    @Autowired
    public VariablesService(ApplicationEventPublisher applicationEventPublisher, KubeOperator operator, NamespaceProvider namespaceProvider, @Value(value="${kubernetes.variables-secret.label}") String kubeSecretsLabel, @Value(value="${kubernetes.variables-secret.name}") String kubeSecretV2Name) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.operator = operator;
        this.namespaceProvider = namespaceProvider;
        this.kubeSecretV2Name = kubeSecretV2Name;
        this.kubeSecretsLabel = Pair.of((Object)kubeSecretsLabel, (Object)"secured");
    }

    public String injectVariables(String text) {
        return this.injectVariables(text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String injectVariables(String text, boolean escapeDesignTimeVariables) {
        if (text == null) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            for (Map.Entry entry : this.mergedVariables.entrySet()) {
                if (!((String)entry.getValue()).trim().isEmpty()) continue;
                text = text.replaceAll("(&amp;)?[a-zA-Z0-9_-]+=#?\\{" + (String)entry.getKey() + "\\}", "");
            }
            text = !escapeDesignTimeVariables ? this.substitutor.replace(text) : this.substitutorEscaped.replace(text);
        }
        finally {
            this.lock.readLock().unlock();
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(text);
        if (matcher.find()) {
            throw new DeploymentRetriableException("Couldn't resolve variables. " + matcher.group(0) + " variable doesn't exist");
        }
        return text;
    }

    public void injectVariablesToExchangeProperties(Map<String, Object> properties) {
        ((MergedVariablesMap)properties.computeIfAbsent("variables", k -> new MergedVariablesMap())).putAll(this.mergedVariables);
    }

    public void refreshSecuredVariables() {
        this.securedVariables = this.pollSecuredVariables();
        this.mergeVariables();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SecuredVariablesUpdatedEvent((Object)this, this.isInitialSecuredEvent));
        if (this.isInitialSecuredEvent) {
            this.isInitialSecuredEvent = false;
        }
    }

    public void updateCommonVariables(@NonNull Map<String, String> variables) {
        if (variables == null) {
            throw new NullPointerException("variables is marked non-null but is null");
        }
        this.commonVariables = variables = this.patchNamespaceValue(variables);
        this.mergeVariables();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new CommonVariablesUpdatedEvent((Object)this, this.isInitialCommonEvent));
        if (this.isInitialCommonEvent) {
            this.isInitialCommonEvent = false;
        }
    }

    private Map<String, String> patchNamespaceValue(@NotNull Map<String, String> variables) {
        if (variables.isEmpty()) {
            return Map.of(NAMESPACE_VARIABLE, this.namespaceProvider.getNamespace());
        }
        variables.put(NAMESPACE_VARIABLE, this.namespaceProvider.getNamespace());
        return variables;
    }

    private Map<String, String> pollSecuredVariables() {
        ConcurrentHashMap<String, String> securedVariables = new ConcurrentHashMap<String, String>();
        try {
            for (Map.Entry secretEntry : this.operator.getAllSecretsWithLabel(this.kubeSecretsLabel).entrySet()) {
                String secretName = (String)secretEntry.getKey();
                Map variables = (Map)secretEntry.getValue();
                for (Map.Entry variablesEntry : variables.entrySet()) {
                    String key = this.kubeSecretV2Name.equals(secretName) ? (String)variablesEntry.getKey() : secretName + SECRET_VARIABLE_SEPARATOR + (String)variablesEntry.getKey();
                    securedVariables.put(key, (String)variablesEntry.getValue());
                }
            }
        }
        catch (KubeApiException e) {
            if (this.operator.isDevmode().booleanValue()) {
                log.debug("Can't to get secured variables from k8s");
            }
            log.warn("Failed to get secured variables from k8s", (Throwable)e);
            throw e;
        }
        return securedVariables;
    }

    private void mergeVariables() {
        this.lock.writeLock().lock();
        try {
            this.mergedVariables = new MergedVariablesMap();
            this.mergedVariables.putAll(this.commonVariables);
            this.mergedVariables.putAll(this.securedVariables);
            this.substitutor = this.buildSubst(this.mergedVariables, "#{");
            HashMap<String, String> variablesToEscape = new HashMap<String, String>(this.mergedVariables);
            variablesToEscape.forEach((k, v) -> variablesToEscape.replace((String)k, StringEscapeUtils.escapeXml10((String)v)));
            this.substitutorEscaped = this.buildSubst(variablesToEscape, "#{");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private StringSubstitutor buildSubst(Map<String, String> variables, String prefix) {
        StringSubstitutor substitutor = new StringSubstitutor(variables);
        substitutor.setVariablePrefix(prefix).setVariableSuffix("}").setPreserveEscapes(true).setEnableUndefinedVariableException(false).setDisableSubstitutionInValues(true).setEnableSubstitutionInVariables(false);
        return substitutor;
    }

    public boolean hasVariableReferences(String text) {
        return VARIABLE_PATTERN.matcher(text).find();
    }
}

