/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel;

import java.io.UnsupportedEncodingException;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KafkaHeaderStringDeserializer
implements KafkaHeaderDeserializer {
    private static final Logger log = LoggerFactory.getLogger(KafkaHeaderStringDeserializer.class);
    private final String encoding = "UTF8";

    public Object deserialize(String key, byte[] value) {
        try {
            return value == null ? null : new String(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Error when deserializing kafka headers from byte[] to string due to unsupported encoding " + this.encoding);
            return value;
        }
    }
}

