/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.rabbitmq.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.rabbitmq.client.LongString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongStringSerializer
extends StdSerializer<LongString> {
    private static final Logger log = LoggerFactory.getLogger(LongStringSerializer.class);

    public LongStringSerializer(Class<LongString> t) {
        super(t);
    }

    public void serialize(LongString value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        try {
            generator.writeString(new String(value.getBytes(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            log.warn("Exception while serializing {} object", (Object)LongString.class.getName(), (Object)e);
            throw e;
        }
    }
}

