/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.history;

import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.spi.MessageHistoryFactory;

public class FilteringMessageHistoryFactory
implements MessageHistoryFactory {
    private final Predicate<FilteringEntity> filter;
    private final MessageHistoryFactory factory;

    public FilteringMessageHistoryFactory(Predicate<FilteringEntity> filter, MessageHistoryFactory factory) {
        this.filter = filter;
        this.factory = factory;
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode node, Exchange exchange) {
        return this.filter.test(new FilteringEntity(routeId, node, exchange)) ? this.factory.newMessageHistory(routeId, node, exchange) : null;
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode node, long timestamp, Exchange exchange) {
        return this.filter.test(new FilteringEntity(routeId, node, exchange)) ? this.factory.newMessageHistory(routeId, node, timestamp, exchange) : null;
    }

    public boolean isCopyMessage() {
        return this.factory.isCopyMessage();
    }

    public void setCopyMessage(boolean copyMessage) {
        this.factory.setCopyMessage(copyMessage);
    }

    public String getNodePattern() {
        return this.factory.getNodePattern();
    }

    public void setNodePattern(String nodePattern) {
        this.factory.setNodePattern(nodePattern);
    }

    public CamelContext getCamelContext() {
        return this.factory.getCamelContext();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.factory.setCamelContext(camelContext);
    }

    public void start() {
        this.factory.start();
    }

    public void stop() {
        this.factory.stop();
    }

    public record FilteringEntity(String routeId, NamedNode node, Exchange exchange) {
    }
}

