/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.metrics;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConsumer;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomEndpoint;
import org.qubership.integration.platform.engine.registry.GatewayHttpRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.stereotype.Component;

@Component
public class CamelServletObservationConvention
extends DefaultServerRequestObservationConvention {
    private static final Logger log = LoggerFactory.getLogger(CamelServletObservationConvention.class);
    private final GatewayHttpRegistry httpRegistry;

    @Autowired
    public CamelServletObservationConvention(GatewayHttpRegistry httpRegistry) {
        this.httpRegistry = httpRegistry;
    }

    @NotNull
    public KeyValues getLowCardinalityKeyValues(@NotNull ServerRequestObservationContext context) {
        CamelServlet camelServlet;
        HttpConsumer consumer;
        KeyValues values = super.getLowCardinalityKeyValues(context);
        if (((HttpServletRequest)context.getCarrier()).getHttpServletMapping().getServletName().equals("CamelServlet") && !Objects.isNull(consumer = (camelServlet = (CamelServlet)this.httpRegistry.getCamelServlet("CamelServlet")).getServletResolveConsumerStrategy().resolve((HttpServletRequest)context.getCarrier(), camelServlet.getConsumers()))) {
            ServletCustomEndpoint servletCustomEndpoint;
            HttpCommonEndpoint endpoint = consumer.getEndpoint();
            values = values.and(new KeyValue[]{KeyValue.of((String)"uri", (String)("/routes" + endpoint.getPath()))});
            if (endpoint instanceof ServletCustomEndpoint && (servletCustomEndpoint = (ServletCustomEndpoint)endpoint).getTagsProvider() != null) {
                values = values.and((Iterable)servletCustomEndpoint.getTagsProvider().get());
            }
        }
        return values;
    }
}

