/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class DeploymentThreadPoolConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DeploymentThreadPoolConfiguration.class);

    @Bean(name={"deploymentExecutor"})
    Executor deploymentExecutor(@Value(value="${qip.deployments.thread-pool.core-size:3}") int corePoolSize, @Value(value="${qip.deployments.thread-pool.max-size:3}") int maxPoolSize) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        log.debug("Deployment task executor thread pool size: core = {}, max = {}", (Object)corePoolSize, (Object)maxPoolSize);
        return executor;
    }
}

