/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.camel.quartz;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.quartz.SchedulerException;
import org.qubership.integration.platform.engine.camel.scheduler.StdSchedulerFactoryProxy;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamelQuartzConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CamelQuartzConfiguration.class);
    public static final String DATASOURCE_NAME_PREFIX = "camelQuartzDatasource";
    private static final String DEV_DB_SCHEMA = "engine";
    private static DataSource qrtzDataSource;
    private final String qrtzSchemaName;
    private final ServerConfiguration serverConfiguration;
    @Value(value="${qip.camel.component.quartz.thread-pool-count}")
    private String threadPoolCount;

    @Autowired
    public CamelQuartzConfiguration(ServerConfiguration serverConfiguration, @Qualifier(value="qrtzDataSource") DataSource qrtzDataSource, @Value(value="${spring.jpa.properties.hibernate.default_schema}") String defaultSchemaName) {
        this.serverConfiguration = serverConfiguration;
        CamelQuartzConfiguration.qrtzDataSource = qrtzDataSource;
        this.qrtzSchemaName = defaultSchemaName;
    }

    @Bean(value={"schedulerFactoryProxy"})
    public StdSchedulerFactoryProxy schedulerFactoryProxy(@Qualifier(value="camelQuartzPropertiesCustomizer") Consumer<Properties> propCustomizer) throws SchedulerException {
        log.debug("Create stdSchedulerFactoryProxy");
        return new StdSchedulerFactoryProxy(this.camelQuartzProperties(propCustomizer));
    }

    @Bean(value={"camelQuartzPropertiesCustomizer"})
    @ConditionalOnMissingBean(name={"camelQuartzPropertiesCustomizer"})
    Consumer<Properties> camelQuartzPropertiesCustomizer() {
        return this::addDevDataSource;
    }

    public static String getPropDataSourcePrefix() {
        String datasourceName = DATASOURCE_NAME_PREFIX;
        String propDatasourcePrefix = "org.quartz.dataSource." + datasourceName + ".";
        return propDatasourcePrefix;
    }

    public Properties camelQuartzProperties(Consumer<Properties> propCustomizer) {
        Properties properties = new Properties();
        propCustomizer.accept(properties);
        properties.setProperty("org.quartz.scheduler.instanceName", "engine-" + this.serverConfiguration.getDomain());
        properties.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        properties.setProperty("org.quartz.scheduler.jobFactory.class", "org.quartz.simpl.SimpleJobFactory");
        properties.setProperty("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
        properties.setProperty("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        String datasourceName = DATASOURCE_NAME_PREFIX;
        properties.setProperty("org.quartz.jobStore.dataSource", datasourceName);
        properties.setProperty("org.quartz.jobStore.tablePrefix", this.qrtzSchemaName + ".QRTZ_");
        properties.setProperty("org.quartz.jobStore.isClustered", "true");
        properties.setProperty("org.quartz.jobStore.misfireThreshold", "15000");
        properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        properties.setProperty("org.quartz.threadPool.threadCount", this.threadPoolCount);
        properties.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
        return properties;
    }

    private void addDevDataSource(Properties properties) {
        DataSource dataSource = qrtzDataSource;
        if (!(dataSource instanceof HikariDataSource)) {
            log.error("Failed to get database parameters for CamelQuartzConfiguration. DataSource instance is not HikariDataSource, camel quartz scheduler may be not work properly!");
            throw new BeanInitializationException("Failed to create CamelQuartzConfiguration bean");
        }
        HikariDataSource dataSource2 = (HikariDataSource)dataSource;
        String propDatasourcePrefix = CamelQuartzConfiguration.getPropDataSourcePrefix();
        String url = dataSource2.getJdbcUrl() + "?currentSchema=engine";
        String username = dataSource2.getUsername();
        String password = dataSource2.getPassword();
        properties.setProperty(propDatasourcePrefix + "driver", "org.postgresql.Driver");
        properties.setProperty(propDatasourcePrefix + "URL", url);
        properties.setProperty(propDatasourcePrefix + "user", username);
        properties.setProperty(propDatasourcePrefix + "password", password);
        properties.setProperty(propDatasourcePrefix + "maxConnections", "12");
    }

    public static DataSource getDataSource() {
        if (qrtzDataSource != null) {
            return qrtzDataSource;
        }
        throw new RuntimeException("DataSource not available now!");
    }
}

