/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.SimpleField;
import java.util.List;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;

public class GetKeysFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "getKeys";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 1) {
            String message = String.format("%s function expects 1 argument.", this.getName());
            throw new ParseException(message);
        }
        Expression parentExpression = args.get(0);
        return context -> {
            Field field = parentExpression.evaluate(context);
            List<Field> keys = FieldUtils.getChildren(field).stream().map(f -> {
                SimpleField result = new SimpleField();
                result.setCollectionType(CollectionType.NONE);
                result.setFieldType(FieldType.STRING);
                result.setValue((Object)f.getName());
                result.setName(f.getName());
                return result;
            }).toList();
            for (int i = 0; i < keys.size(); ++i) {
                keys.get(i).setPath(String.format("%s/$keys<%d>", field.getPath(), i));
            }
            FieldGroup group = new FieldGroup();
            group.setFieldType(FieldType.STRING);
            group.setCollectionType(CollectionType.ARRAY);
            group.setPath(field.getPath() + "/$keys<>");
            group.setName("keys");
            group.getField().addAll(keys);
            return group;
        };
    }
}

