/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.deployment.update;

public enum RouteType {
    EXTERNAL_TRIGGER,
    PRIVATE_TRIGGER,
    EXTERNAL_PRIVATE_TRIGGER,
    INTERNAL_TRIGGER,
    EXTERNAL_SENDER,
    EXTERNAL_SERVICE,
    INTERNAL_SERVICE,
    IMPLEMENTED_SERVICE;


    public static RouteType convertTriggerType(boolean isExternal, boolean isPrivate) {
        if (isPrivate && isExternal) {
            return EXTERNAL_PRIVATE_TRIGGER;
        }
        if (isExternal) {
            return EXTERNAL_TRIGGER;
        }
        if (isPrivate) {
            return PRIVATE_TRIGGER;
        }
        return INTERNAL_TRIGGER;
    }

    public static boolean isPrivateTriggerRoute(RouteType routeType) {
        return routeType == PRIVATE_TRIGGER || routeType == EXTERNAL_PRIVATE_TRIGGER;
    }

    public static boolean isPublicTriggerRoute(RouteType routeType) {
        return routeType == EXTERNAL_TRIGGER || routeType == EXTERNAL_PRIVATE_TRIGGER;
    }

    public static boolean triggerRouteCleanupNeeded(RouteType routeType) {
        return routeType == EXTERNAL_TRIGGER || routeType == PRIVATE_TRIGGER || routeType == INTERNAL_TRIGGER;
    }

    public static boolean triggerRouteWithGateway(RouteType routeType) {
        return routeType == EXTERNAL_TRIGGER || routeType == PRIVATE_TRIGGER || routeType == EXTERNAL_PRIVATE_TRIGGER;
    }
}

