/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.opensearch;

import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionInfo {
    private String message;
    private String stackTrace;

    public ExceptionInfo(Exception exception) {
        this.message = exception.getMessage();
        this.stackTrace = ExceptionUtils.getStackTrace((Throwable)exception);
    }

    public static ExceptionInfoBuilder builder() {
        return new ExceptionInfoBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public ExceptionInfo() {
    }

    public ExceptionInfo(String message, String stackTrace) {
        this.message = message;
        this.stackTrace = stackTrace;
    }

    public static class ExceptionInfoBuilder {
        private String message;
        private String stackTrace;

        ExceptionInfoBuilder() {
        }

        public ExceptionInfoBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ExceptionInfoBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public ExceptionInfo build() {
            return new ExceptionInfo(this.message, this.stackTrace);
        }

        public String toString() {
            return "ExceptionInfo.ExceptionInfoBuilder(message=" + this.message + ", stackTrace=" + this.stackTrace + ")";
        }
    }
}

