/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism.model.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.Request;
import org.opensearch.client.transport.GenericSerializable;

public class GenericRequest
implements GenericSerializable,
Request {
    private final String method;
    private final String endpoint;
    private final Collection<Map.Entry<String, String>> headers;
    private final Map<String, String> parameters;
    private final Body body;

    public GenericRequest(String method, String endpoint, Collection<Map.Entry<String, String>> headers) {
        this(method, endpoint, headers, Collections.emptyMap(), null);
    }

    public GenericRequest(String method, String endpoint, Collection<Map.Entry<String, String>> headers, Map<String, String> parameters, @Nullable Body body) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint cannot be null");
        this.headers = Objects.requireNonNull(headers, "headers cannot be null");
        this.parameters = Objects.requireNonNull(parameters, "parameters cannot be null");
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Collection<Map.Entry<String, String>> getHeaders() {
        return Collections.unmodifiableCollection(this.headers);
    }

    public Optional<Body> getBody() {
        return Optional.ofNullable(this.body);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Request{");
        b.append("method='").append(this.method).append('\'');
        b.append(", endpoint='").append(this.endpoint).append('\'');
        if (!this.parameters.isEmpty()) {
            b.append(", params=").append(this.parameters);
        }
        if (this.body != null) {
            b.append(", body=").append(this.body);
        }
        return b.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        GenericRequest other = (GenericRequest)obj;
        return this.method.equals(other.method) && this.endpoint.equals(other.endpoint) && this.parameters.equals(other.parameters) && this.headers.equals(other.headers) && Objects.equals(this.body, other.body);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.endpoint, this.parameters, this.headers, this.body);
    }

    public String serialize(OutputStream out) {
        if (!this.getBody().isPresent()) {
            throw new IllegalStateException("The request has no content body provided.");
        }
        Body b = this.getBody().get();
        try (InputStream in = b.body();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer, 0, 8192)) >= 0) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return b.contentType();
    }
}

