/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.entity;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.time.ZonedDateTime;
import org.hibernate.annotations.Type;

@Entity(name="idempotency_records")
public class IdempotencyRecord {
    @Id
    @Column(columnDefinition="text")
    private String key;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    private JsonNode data;
    @Column(columnDefinition="timestamptz")
    private ZonedDateTime createdAt;
    @Column(columnDefinition="timestamptz")
    private ZonedDateTime expiresAt;

    public static IdempotencyRecordBuilder builder() {
        return new IdempotencyRecordBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public JsonNode getData() {
        return this.data;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setData(JsonNode data) {
        this.data = data;
    }

    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpiresAt(ZonedDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public IdempotencyRecord(String key, JsonNode data, ZonedDateTime createdAt, ZonedDateTime expiresAt) {
        this.key = key;
        this.data = data;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
    }

    public IdempotencyRecord() {
    }

    public static class IdempotencyRecordBuilder {
        private String key;
        private JsonNode data;
        private ZonedDateTime createdAt;
        private ZonedDateTime expiresAt;

        IdempotencyRecordBuilder() {
        }

        public IdempotencyRecordBuilder key(String key) {
            this.key = key;
            return this;
        }

        public IdempotencyRecordBuilder data(JsonNode data) {
            this.data = data;
            return this;
        }

        public IdempotencyRecordBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public IdempotencyRecordBuilder expiresAt(ZonedDateTime expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public IdempotencyRecord build() {
            return new IdempotencyRecord(this.key, this.data, this.createdAt, this.expiresAt);
        }

        public String toString() {
            return "IdempotencyRecord.IdempotencyRecordBuilder(key=" + this.key + ", data=" + String.valueOf(this.data) + ", createdAt=" + String.valueOf(this.createdAt) + ", expiresAt=" + String.valueOf(this.expiresAt) + ")";
        }
    }
}

