/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.mapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointSessionDTO;
import org.qubership.integration.platform.engine.rest.v1.mapper.CheckpointMapper;
import org.qubership.integration.platform.engine.rest.v1.mapper.SessionInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionInfoMapperImpl
implements SessionInfoMapper {
    @Autowired
    private CheckpointMapper checkpointMapper;
    private final DatatypeFactory datatypeFactory;

    public SessionInfoMapperImpl() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public CheckpointSessionDTO asDTO(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return null;
        }
        CheckpointSessionDTO.CheckpointSessionDTOBuilder checkpointSessionDTO = CheckpointSessionDTO.builder();
        checkpointSessionDTO.id(sessionInfo.getId());
        checkpointSessionDTO.started(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(sessionInfo.getStarted()), null));
        checkpointSessionDTO.finished(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(sessionInfo.getFinished()), null));
        checkpointSessionDTO.duration(sessionInfo.getDuration());
        checkpointSessionDTO.executionStatus(sessionInfo.getExecutionStatus());
        checkpointSessionDTO.chainId(sessionInfo.getChainId());
        checkpointSessionDTO.chainName(sessionInfo.getChainName());
        checkpointSessionDTO.engineAddress(sessionInfo.getEngineAddress());
        checkpointSessionDTO.loggingLevel(sessionInfo.getLoggingLevel());
        checkpointSessionDTO.snapshotName(sessionInfo.getSnapshotName());
        checkpointSessionDTO.correlationId(sessionInfo.getCorrelationId());
        checkpointSessionDTO.checkpoints(this.checkpointMapper.asDTO(sessionInfo.getCheckpoints()));
        return checkpointSessionDTO.build();
    }

    @Override
    public List<CheckpointSessionDTO> asDTO(List<SessionInfo> sessionInfo) {
        if (sessionInfo == null) {
            return null;
        }
        ArrayList<CheckpointSessionDTO> list = new ArrayList<CheckpointSessionDTO>(sessionInfo.size());
        for (SessionInfo sessionInfo1 : sessionInfo) {
            list.add(this.asDTO(sessionInfo1));
        }
        return list;
    }

    private String xmlGregorianCalendarToString(XMLGregorianCalendar xcal, String dateFormat) {
        if (xcal == null) {
            return null;
        }
        if (dateFormat == null) {
            return xcal.toString();
        }
        Date d = xcal.toGregorianCalendar().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(d);
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(c);
    }
}

