/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.masking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.engine.errorhandling.LoggingMaskingException;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class MaskingService {
    private static final Logger log = LoggerFactory.getLogger(MaskingService.class);
    private static final MimeType SOAP_XML_CONTENT_TYPE = MimeType.valueOf((String)"application/soap+xml");
    private static final MimeType JSON_PATCH_JSON_CONTENT_TYPE = MimeType.valueOf((String)"application/json-patch+json");
    private static final MimeType X_WWW_FORM_URLENCODED_CONTENT_TYPE = MimeType.valueOf((String)"application/x-www-form-urlencoded");
    private final ObjectMapper objectMapper;

    @Autowired
    public MaskingService(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String maskFields(String target, Set<String> fields, MimeType contentType) throws LoggingMaskingException, UnsupportedMediaTypeException {
        if (contentType == null) {
            throw new UnsupportedMediaTypeException("Content type is empty, failed to mask fields in payload");
        }
        if (MimeTypeUtils.APPLICATION_JSON.equalsTypeAndSubtype(contentType) || JSON_PATCH_JSON_CONTENT_TYPE.equalsTypeAndSubtype(contentType)) {
            try {
                return this.maskJSON(target, fields);
            }
            catch (JsonProcessingException e) {
                throw new LoggingMaskingException("Invalid JSON document, failed to mask fields in payload", (Exception)((Object)e));
            }
        }
        if (MimeTypeUtils.APPLICATION_XML.equalsTypeAndSubtype(contentType) || MimeTypeUtils.TEXT_XML.equalsTypeAndSubtype(contentType) || SOAP_XML_CONTENT_TYPE.equalsTypeAndSubtype(contentType)) {
            try {
                return this.maskXML(target, fields);
            }
            catch (Exception e) {
                throw new LoggingMaskingException("Invalid XML document, failed to mask fields in payload", e);
            }
        }
        if (X_WWW_FORM_URLENCODED_CONTENT_TYPE.equalsTypeAndSubtype(contentType)) {
            try {
                return this.maskXwwwUrlencoded(target, fields);
            }
            catch (Exception e) {
                throw new LoggingMaskingException("Invalid x-www-form-urlencoded data, failed to mask fields in payload", e);
            }
        }
        throw new UnsupportedMediaTypeException("Content type " + contentType.toString() + " not supported for masking");
    }

    public void maskFields(Map<String, String> target, Set<String> maskedFields) {
        for (String field : maskedFields) {
            target.computeIfPresent(field, (key, value) -> "******");
        }
    }

    public void maskPropertiesFields(Map<String, SessionElementProperty> target, Set<String> maskedFields) {
        for (String field : maskedFields) {
            target.computeIfPresent(field, (key, value) -> {
                value.setValue("******");
                return value;
            });
        }
    }

    public String maskJSON(String target, Set<String> fields) throws JsonProcessingException {
        JsonNode jsonNode = this.objectMapper.readTree(target);
        this.modifyJsonTree(jsonNode, fields);
        return this.objectMapper.writeValueAsString((Object)jsonNode);
    }

    private String maskXML(String target, Set<String> fields) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(target)));
        document.getDocumentElement().normalize();
        Element root = document.getDocumentElement();
        this.modifyXmlTree(root, fields);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("standalone", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    private String maskXwwwUrlencoded(String target, Set<String> fields) {
        List<Pair> maskedEntries = Arrays.stream(target.split("&")).map(kv -> {
            String[] split = kv.split("=");
            String decodedKey = URLDecoder.decode(split[0], StandardCharsets.UTF_8);
            String value = split.length > 1 ? split[1] : "";
            return Pair.of((Object)split[0], (Object)(fields.contains(decodedKey) ? "******" : value));
        }).toList();
        return maskedEntries.stream().map(pair -> (String)pair.getKey() + "=" + (String)pair.getValue()).collect(Collectors.joining("&"));
    }

    private void modifyJsonTree(JsonNode root, Set<String> maskedFields) {
        this.modifyJsonTree(root, maskedFields, false);
    }

    private void modifyJsonTree(JsonNode root, Set<String> maskedFields, boolean maskArray) {
        block5: {
            block4: {
                if (!root.isObject()) break block4;
                Iterator fields = root.fieldNames();
                while (fields.hasNext()) {
                    String fieldName = (String)fields.next();
                    JsonNode fieldValue = root.get(fieldName);
                    boolean fieldMatches = maskedFields.contains(fieldName);
                    if (fieldValue.isValueNode() && fieldMatches) {
                        ((ObjectNode)root).set(fieldName, (JsonNode)new TextNode("******"));
                        continue;
                    }
                    this.modifyJsonTree(fieldValue, maskedFields, fieldMatches);
                }
                break block5;
            }
            if (!root.isArray()) break block5;
            ArrayNode arrayNode = (ArrayNode)root;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode arrayElement = arrayNode.get(i);
                if (arrayElement.isValueNode() && maskArray) {
                    arrayNode.set(i, (JsonNode)new TextNode("******"));
                    continue;
                }
                this.modifyJsonTree(arrayElement, maskedFields, false);
            }
        }
    }

    private void modifyXmlTree(Node root, Set<String> maskedFields) {
        if (root.getNodeType() == 1) {
            NodeList fields = root.getChildNodes();
            int childrenCount = fields.getLength();
            if (childrenCount == 0 && root.hasAttributes()) {
                this.maskAttributes(root, maskedFields);
            }
            for (int i = 0; i < childrenCount; ++i) {
                Node child = fields.item(i);
                if (child.getNodeType() == 3 && childrenCount == 1) {
                    if (maskedFields.contains(root.getNodeName())) {
                        child.setTextContent("******");
                    }
                    if (!root.hasAttributes()) continue;
                    this.maskAttributes(root, maskedFields);
                    continue;
                }
                this.modifyXmlTree(child, maskedFields);
            }
        }
    }

    private void maskAttributes(Node root, Set<String> maskedFields) {
        NamedNodeMap namedNodeMap = root.getAttributes();
        maskedFields.forEach(mf -> {
            Node childAttribute = namedNodeMap.getNamedItem((String)mf);
            if (childAttribute != null) {
                childAttribute.setTextContent("******");
            }
        });
    }
}

