/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Objects;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.configuration.ApplicationAutoConfiguration;
import org.qubership.integration.platform.engine.controlplane.ControlPlaneException;
import org.qubership.integration.platform.engine.controlplane.ControlPlaneService;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentRouteUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.RouteType;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.deployment.processing.DeploymentProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnBeforeDeploymentContextCreated;
import org.qubership.integration.platform.engine.util.SimpleHttpUriUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={ControlPlaneService.class})
@OnBeforeDeploymentContextCreated
public class RegisterRoutesInControlPlaneAction
implements DeploymentProcessingAction {
    private final VariablesService variablesService;
    private final ControlPlaneService controlPlaneService;
    private final ApplicationAutoConfiguration applicationConfiguration;

    @Autowired
    public RegisterRoutesInControlPlaneAction(VariablesService variablesService, ControlPlaneService controlPlaneService, ApplicationAutoConfiguration applicationConfiguration) {
        this.variablesService = variablesService;
        this.controlPlaneService = controlPlaneService;
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public void execute(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) {
        this.resolveVariablesInRoutes(deploymentConfiguration);
        List<DeploymentRouteUpdate> gatewayTriggersRoutes = deploymentConfiguration.getRoutes().stream().filter(route -> RouteType.triggerRouteWithGateway(route.getType())).peek(externalRoute -> externalRoute.setPath("/" + StringUtils.strip((String)externalRoute.getPath(), (String)"/"))).toList();
        try {
            this.controlPlaneService.postPublicEngineRoutes(gatewayTriggersRoutes.stream().filter(route -> RouteType.isPublicTriggerRoute(route.getType())).toList(), this.applicationConfiguration.getDeploymentName());
            this.controlPlaneService.postPrivateEngineRoutes(gatewayTriggersRoutes.stream().filter(route -> RouteType.isPrivateTriggerRoute(route.getType())).toList(), this.applicationConfiguration.getDeploymentName());
            this.controlPlaneService.removeEngineRoutesByPathsAndEndpoint(deploymentConfiguration.getRoutes().stream().filter(route -> RouteType.triggerRouteCleanupNeeded(route.getType())).map(route -> Pair.of((Object)route.getPath(), (Object)((Object)route.getType()))).toList(), this.applicationConfiguration.getDeploymentName());
            deploymentConfiguration.getRoutes().stream().filter(route -> route.getType() == RouteType.EXTERNAL_SENDER || route.getType() == RouteType.EXTERNAL_SERVICE).forEach(route -> this.controlPlaneService.postEgressGatewayRoutes(RegisterRoutesInControlPlaneAction.formatServiceRoutes(route)));
        }
        catch (ControlPlaneException e) {
            throw new DeploymentRetriableException(e);
        }
    }

    private void resolveVariablesInRoutes(DeploymentConfiguration deploymentConfiguration) {
        deploymentConfiguration.getRoutes().stream().filter(route -> Objects.nonNull(route.getVariableName()) && (RouteType.EXTERNAL_SENDER == route.getType() || RouteType.EXTERNAL_SERVICE == route.getType())).filter(route -> this.variablesService.hasVariableReferences(route.getPath())).forEach(route -> route.setPath(this.variablesService.injectVariables(route.getPath())));
    }

    @NotNull
    public static DeploymentRouteUpdate formatServiceRoutes(DeploymentRouteUpdate route) {
        DeploymentRouteUpdate routeUpdate = route;
        if (Objects.nonNull(routeUpdate.getVariableName()) && RouteType.EXTERNAL_SERVICE.equals((Object)routeUpdate.getType())) {
            routeUpdate = routeUpdate.toBuilder().build();
            try {
                routeUpdate.setPath(SimpleHttpUriUtils.formatUri(routeUpdate.getPath()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            String pathHash = RegisterRoutesInControlPlaneAction.getCPRouteHash(routeUpdate);
            if (!StringUtils.isBlank((CharSequence)pathHash)) {
                routeUpdate.setGatewayPrefix(routeUpdate.getGatewayPrefix() + "/" + pathHash);
            }
        }
        return routeUpdate;
    }

    private static String getCPRouteHash(DeploymentRouteUpdate route) {
        if (route.getPath() == null) {
            return null;
        }
        String strToHash = StringUtils.joinWith((String)",", (Object[])new Object[]{route.getPath(), route.getConnectTimeout()});
        return DigestUtils.sha1Hex((String)strToHash);
    }
}

