/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import io.micrometer.core.instrument.Tag;
import java.util.Collection;
import org.apache.camel.component.kafka.DefaultKafkaClientFactory;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.components.kafka.TaggedMetricsKafkaClientFactory;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.ChainElementTypeHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.MetricTagsHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
@OnAfterDeploymentContextCreated
public class KafkaElementDependencyBinder
extends ElementProcessingAction {
    public static final int ORDER = Integer.MIN_VALUE;
    private final MetricsStore metricsStore;
    private final MetricTagsHelper metricTagsHelper;

    @Autowired
    public KafkaElementDependencyBinder(MetricsStore metricsStore, MetricTagsHelper metricTagsHelper) {
        this.metricsStore = metricsStore;
        this.metricTagsHelper = metricTagsHelper;
    }

    @Override
    public boolean applicableTo(ElementProperties properties) {
        String elementType = properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString(elementType);
        return ChainElementType.isKafkaAsyncElement(chainElementType) && (!ChainElementTypeHelper.isServiceCallOrAsyncApiTrigger(chainElementType) || "kafka".equals(properties.getProperties().get("integrationOperationProtocolType")));
    }

    @Override
    public void apply(SpringCamelContext context, ElementProperties properties, DeploymentInfo deploymentInfo) {
        String elementId = properties.getElementId();
        DefaultKafkaClientFactory defaultFactory = new DefaultKafkaClientFactory();
        Collection<Tag> tags = this.metricTagsHelper.buildMetricTagsLegacy(deploymentInfo, properties, deploymentInfo.getChainName());
        String maasClassifier = properties.getProperties().get("maasClassifier");
        if (!StringUtils.isEmpty((CharSequence)maasClassifier)) {
            tags.add(Tag.of((String)"maas_classifier", (String)maasClassifier));
        }
        Object kafkaClientFactory = this.metricsStore.isMetricsEnabled() ? new TaggedMetricsKafkaClientFactory((KafkaClientFactory)defaultFactory, this.metricsStore.getMeterRegistry(), tags) : defaultFactory;
        context.getRegistry().bind(elementId, KafkaClientFactory.class, kafkaClientFactory);
        context.getRegistry().bind(elementId + "-v2", KafkaClientFactory.class, kafkaClientFactory);
    }
}

